/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.accFlow;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridExtent;

public class AccFlowAlgorithm
extends GeoAlgorithm {
    private static final double NOT_VISITED = -1.0;
    public static final String FLOWACC = "FLOWACC";
    public static final String CONVERGENCE = "CONVERGENCE";
    public static final String METHOD = "METHOD";
    public static final String DEM = "DEM";
    public static final String WEIGHTS = "WEIGHTS";
    public static final int D8 = 0;
    public static final int RHO8 = 1;
    public static final int DINF = 2;
    public static final int MFD = 3;
    private static final int[] m_iOffsetX;
    private static final int[] m_iOffsetY;
    private int m_iMethod;
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer[] m_Flow;
    private double m_dConvergence;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Weights = null;
    private IRasterLayer m_AccFlow;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        m_iOffsetX = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        m_iOffsetY = nArray2;
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Weights = this.m_Parameters.getParameterValueAsRasterLayer(WEIGHTS);
        this.m_dConvergence = this.m_Parameters.getParameterValueAsDouble(CONVERGENCE);
        this.m_AccFlow = this.getNewRasterLayer(FLOWACC, Sextante.getText((String)"Acumulacion_de_flujo"), 4, this.m_DEM);
        this.m_AccFlow.assign(-1.0);
        GridExtent extent = this.m_AccFlow.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        if (this.m_Weights != null) {
            this.m_Weights.setWindowExtent(extent);
        }
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.m_Flow = new IRasterLayer[8];
        int i = 0;
        while (i < this.m_Flow.length) {
            this.m_Flow[i] = this.getTempRasterLayer(4, extent);
            ++i;
        }
        this.calculateFlows();
        this.calculateAccFlows();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        this.m_AccFlow.multiply(this.m_AccFlow.getWindowCellSize() * this.m_AccFlow.getWindowCellSize());
        return true;
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"D8"), Sextante.getText((String)"Rho8"), Sextante.getText((String)"DInfinity"), Sextante.getText((String)"MFD_direccion_de_flujo_multiple")};
        this.setName(Sextante.getText((String)"Acumulacion_de_flujo"));
        this.setGeneratesUserDefinedRasterOutput(true);
        this.setGroup(Sextante.getText((String)"Analisis_hidrologico_basico"));
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.m_Parameters.addInputRasterLayer(WEIGHTS, Sextante.getText((String)"Ponderacion_de_celdas"), false);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Metodo"), sMethod);
            this.m_Parameters.addNumericalValue(CONVERGENCE, Sextante.getText((String)"Factor_de_convergencia_para_MFD"), 1.1, 2);
            this.addOutputRasterLayer(FLOWACC, Sextante.getText((String)"Acumulacion_de_flujo"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateFlows() {
        int y = 0;
        while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
            int x = 0;
            while (x < this.m_iNX) {
                switch (this.m_iMethod) {
                    case 0: {
                        this.doD8(x, y);
                        break;
                    }
                    case 1: {
                        this.doRho8(x, y);
                        break;
                    }
                    case 2: {
                        this.doDInf(x, y);
                        break;
                    }
                    case 3: {
                        this.doMFD(x, y);
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    private void calculateAccFlows() {
        int y = 0;
        while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
            int x = 0;
            while (x < this.m_iNX) {
                this.getFlow(x, y);
                ++x;
            }
            ++y;
        }
    }

    private void getFlow(int x, int y) {
        if (this.m_AccFlow.getCellValueAsDouble(x, y) != -1.0 || this.m_Task.isCanceled()) {
            return;
        }
        double dWeight = this.m_Weights != null ? this.m_Weights.getCellValueAsDouble(x, y) : 1.0;
        double dValue = this.m_DEM.getCellValueAsDouble(x, y);
        if (!this.m_DEM.isNoDataValue(dValue)) {
            this.m_AccFlow.setCellValue(x, y, dWeight);
            int i = 0;
            int j = 4;
            while (i < 8) {
                double dFlow;
                int ix = x + m_iOffsetX[i];
                int iy = y + m_iOffsetY[i];
                dValue = this.m_DEM.getCellValueAsDouble(ix, iy);
                if (!this.m_DEM.isNoDataValue(dValue) && (dFlow = this.m_Flow[j].getCellValueAsDouble(ix, iy)) > 0.0) {
                    this.getFlow(ix, iy);
                    dValue = this.m_AccFlow.getCellValueAsDouble(ix, iy) * dFlow;
                    double dValue2 = this.m_AccFlow.getCellValueAsDouble(x, y);
                    this.m_AccFlow.setCellValue(x, y, dValue + dValue2);
                }
                ++i;
                j = (j + 1) % 8;
            }
        }
    }

    private void doD8(int x, int y) {
        int iDirection = this.m_DEM.getDirToNextDownslopeCell(x, y);
        if (iDirection >= 0) {
            this.m_Flow[iDirection % 8].setCellValue(x, y, 1.0);
        }
    }

    private void doRho8(int x, int y) {
        double dAspect = Math.toDegrees(this.m_DEM.getAspect(x, y));
        if (dAspect >= 0.0) {
            int iDirection = (int)(dAspect / 45.0);
            if (dAspect % 45.0 / 45.0 > Math.random()) {
                ++iDirection;
            }
            this.m_Flow[iDirection %= 8].setCellValue(x, y, 1.0);
        }
    }

    private void doDInf(int x, int y) {
        double dAspect = Math.toDegrees(this.m_DEM.getAspect(x, y));
        if (dAspect >= 0.0) {
            int iDirection = (int)(dAspect / 45.0);
            dAspect = dAspect % 45.0 / 45.0;
            this.m_Flow[iDirection % 8].setCellValue(x, y, 1.0 - dAspect);
            this.m_Flow[(iDirection + 1) % 8].setCellValue(x, y, dAspect);
        }
    }

    private void doMFD(int x, int y) {
        double dFlow;
        double z = this.m_DEM.getCellValueAsDouble(x, y);
        double dzSum = 0.0;
        int i = 0;
        while (i < 8) {
            double dDifZ;
            int ix = x + m_iOffsetX[i];
            int iy = y + m_iOffsetY[i];
            double z2 = this.m_DEM.getCellValueAsDouble(ix, iy);
            if (!this.m_DEM.isNoDataValue(z2) && (dDifZ = z - z2) > 0.0) {
                dFlow = Math.pow(dDifZ / this.m_DEM.getDistToNeighborInDir(i), this.m_dConvergence);
                dzSum += dFlow;
                this.m_Flow[i].setCellValue(x, y, dFlow);
            }
            ++i;
        }
        if (dzSum > 0.0) {
            i = 0;
            while (i < 8) {
                dFlow = this.m_Flow[i].getCellValueAsDouble(x, y);
                if (dFlow > 0.0) {
                    this.m_Flow[i].setCellValue(x, y, dFlow / dzSum);
                }
                ++i;
            }
        }
    }
}

