/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.cFactorFromNDVI;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class CFactorFromNDVIAlgorithm
extends GeoAlgorithm {
    public static final String ALPHA = "ALPHA";
    public static final String BETA = "BETA";
    public static final String NDVI = "NDVI";
    public static final String CFACTOR = "CFACTOR";
    private IRasterLayer m_NDVI = null;
    private IRasterLayer m_CFactor;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_NDVI = this.m_Parameters.getParameterValueAsRasterLayer(NDVI);
        this.m_CFactor = this.getNewRasterLayer(CFACTOR, "C", 4);
        double dAlpha = this.m_Parameters.getParameterValueAsDouble(ALPHA);
        double dBeta = this.m_Parameters.getParameterValueAsDouble(BETA);
        this.m_NDVI.setWindowExtent(this.m_GridExtent);
        int iNX = this.m_NDVI.getNX();
        int iNY = this.m_NDVI.getNY();
        int y = 0;
        while (y < iNY && this.setProgress(y, iNY)) {
            int x = 0;
            while (x < iNX) {
                double dNDVI = this.m_NDVI.getCellValueAsDouble(x, y);
                if (this.m_NDVI.isNoDataValue(dNDVI)) {
                    this.m_CFactor.setNoData(x, y);
                } else {
                    this.m_CFactor.setCellValue(x, y, -dAlpha * dNDVI / (dBeta - dNDVI));
                }
                ++x;
            }
            ++y;
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"C_NDVI"));
        this.setGroup(Sextante.getText((String)"Indices_y_otros_parametros_hidrologicos"));
        this.setGeneratesUserDefinedRasterOutput(true);
        try {
            this.m_Parameters.addInputRasterLayer(NDVI, NDVI, true);
            this.m_Parameters.addNumericalValue(ALPHA, "Alpha", 1.0, 2);
            this.m_Parameters.addNumericalValue(BETA, "Beta", 2.0, 2);
            this.addOutputRasterLayer(CFACTOR, Sextante.getText((String)"C"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

