/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.cellBalance;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridExtent;

public class CellBalanceAlgorithm
extends GeoAlgorithm {
    private static final double RAD_TO_DEG = 57.29577951308232;
    private static final int[] m_iOffsetX;
    private static final int[] m_iOffsetY;
    public static final String METHOD = "METHOD";
    public static final String DEM = "DEM";
    public static final String WEIGHTS = "WEIGHTS";
    public static final String CONVERGENCE = "CONVERGENCE";
    public static final String CELLBALANCE = "CELLBALANCE";
    private int m_iMethod;
    private int m_iNX;
    private int m_iNY;
    private double m_dConvergence;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Weights = null;
    private IRasterLayer m_CellBalance;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        m_iOffsetX = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        m_iOffsetY = nArray2;
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Weights = this.m_Parameters.getParameterValueAsRasterLayer(WEIGHTS);
        this.m_dConvergence = this.m_Parameters.getParameterValueAsDouble(CONVERGENCE);
        this.m_CellBalance = this.getNewRasterLayer(CELLBALANCE, Sextante.getText((String)"Balance_neto"), 4, this.m_DEM);
        GridExtent extent = this.m_CellBalance.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        this.m_Weights.setWindowExtent(extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.calculateInFlows();
        this.substractOutFlows();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"D8"), Sextante.getText((String)"DInfinity"), Sextante.getText((String)"MFD_direccion_de_flujo_multiple")};
        this.setName(Sextante.getText((String)"Balance_neto_por_celdas"));
        this.setGroup(Sextante.getText((String)"Indices_y_otros_parametros_hidrologicos"));
        this.setGeneratesUserDefinedRasterOutput(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.m_Parameters.addInputRasterLayer(WEIGHTS, Sextante.getText((String)"Ponderacion_de_celdas"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Metodo"), sMethod);
            this.m_Parameters.addNumericalValue(CONVERGENCE, Sextante.getText((String)"Factor_de_convergencia_para_MFD"), 1.1, 2);
            this.addOutputRasterLayer(CELLBALANCE, Sextante.getText((String)"Balance_neto"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateInFlows() {
        int y = 0;
        while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
            int x = 0;
            while (x < this.m_iNX) {
                switch (this.m_iMethod) {
                    case 0: {
                        this.doD8(x, y);
                        break;
                    }
                    case 1: {
                        this.doDInf(x, y);
                        break;
                    }
                    case 2: {
                        this.doMFD(x, y);
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    private void substractOutFlows() {
        int y = 0;
        while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
            int x = 0;
            while (x < this.m_iNX) {
                double dOut = this.m_Weights.getCellValueAsDouble(x, y);
                if (!this.m_Weights.isNoDataValue(dOut)) {
                    this.m_CellBalance.addToCellValue(x, y, -dOut);
                } else {
                    this.m_CellBalance.setNoData(x, y);
                }
                ++x;
            }
            ++y;
        }
    }

    private void doD8(int x, int y) {
        int iDirection;
        double dWeight = this.m_Weights.getCellValueAsDouble(x, y);
        if (!this.m_Weights.isNoDataValue(dWeight) && (iDirection = this.m_DEM.getDirToNextDownslopeCell(x, y)) >= 0) {
            int ix = x + m_iOffsetX[iDirection];
            int iy = y + m_iOffsetY[iDirection];
            this.m_CellBalance.addToCellValue(ix, iy, dWeight);
        }
    }

    private void doDInf(int x, int y) {
        double dWeight = this.m_Weights.getCellValueAsDouble(x, y);
        if (!this.m_Weights.isNoDataValue(dWeight)) {
            double dAspect = this.m_DEM.getAspect(x, y);
            if ((dAspect *= 57.29577951308232) >= 0.0) {
                int iDirection = (int)(dAspect / 45.0);
                dAspect = dAspect % 45.0 / 45.0;
                int ix = x + m_iOffsetX[iDirection %= 8];
                int iy = y + m_iOffsetY[iDirection];
                this.m_CellBalance.addToCellValue(ix, iy, dWeight * (1.0 - dAspect));
                iDirection = (iDirection + 1) % 8;
                ix = x + m_iOffsetX[iDirection];
                iy = y + m_iOffsetY[iDirection];
                this.m_CellBalance.addToCellValue(ix, iy, dWeight * dAspect);
            }
        }
    }

    private void doMFD(int x, int y) {
        double dWeight = this.m_Weights.getCellValueAsDouble(x, y);
        if (!this.m_Weights.isNoDataValue(dWeight)) {
            int iy;
            int ix;
            double z = this.m_DEM.getCellValueAsDouble(x, y);
            double dzSum = 0.0;
            double[] Flow = new double[8];
            int i = 0;
            while (i < 8) {
                double dDifZ;
                ix = x + m_iOffsetX[i];
                iy = y + m_iOffsetY[i];
                double z2 = this.m_DEM.getCellValueAsDouble(ix, iy);
                if (!this.m_DEM.isNoDataValue(z2) && (dDifZ = z - z2) > 0.0) {
                    Flow[i] = Math.pow(dDifZ / this.m_DEM.getDistToNeighborInDir(i), this.m_dConvergence);
                    dzSum += Flow[i];
                }
                ++i;
            }
            if (dzSum > 0.0) {
                i = 0;
                while (i < 8) {
                    ix = x + m_iOffsetX[i];
                    iy = y + m_iOffsetY[i];
                    if (Flow[i] > 0.0) {
                        this.m_CellBalance.addToCellValue(ix, iy, Flow[i] / dzSum * dWeight);
                    }
                    ++i;
                }
            }
        }
    }
}

