/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.channelNetwork;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.rasterWrappers.GridCell;
import es.unex.sextante.rasterWrappers.GridExtent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;

public class ChannelNetworkAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX;
    private static final int[] m_iOffsetY;
    public static final String METHOD = "METHOD";
    public static final String DEM = "DEM";
    public static final String THRESHOLDLAYER = "THRESHOLDLAYER";
    public static final String THRESHOLD = "THRESHOLD";
    public static final String NETWORK = "NETWORK";
    public static final String NETWORKVECT = "NETWORKVECT";
    private int m_iMethod;
    private int m_iNX;
    private int m_iNY;
    private double m_dThreshold;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Threshold = null;
    private IRasterLayer m_Network;
    private ArrayList m_HeadersAndJunctions;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        m_iOffsetX = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        m_iOffsetY = nArray2;
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Threshold = this.m_Parameters.getParameterValueAsRasterLayer(THRESHOLDLAYER);
        this.m_dThreshold = this.m_Parameters.getParameterValueAsDouble(THRESHOLD);
        this.m_Network = this.getNewRasterLayer(NETWORK, Sextante.getText((String)"Red_de_drenaje"), 3, this.m_Threshold);
        this.m_Network.assign(0.0);
        GridExtent extent = this.m_Network.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        this.m_Threshold.setWindowExtent(extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.calculateChannelNetwork();
        this.m_Network.setNoDataValue(0.0);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Mayor_que"), Sextante.getText((String)"Menor_que")};
        this.setName(Sextante.getText((String)"Red_de_drenaje"));
        this.setGroup(Sextante.getText((String)"Analisis_hidrologico_basico"));
        this.setGeneratesUserDefinedRasterOutput(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.m_Parameters.addInputRasterLayer(THRESHOLDLAYER, Sextante.getText((String)"Capa_umbral"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Tipo_de_umbral"), sMethod);
            this.m_Parameters.addNumericalValue(THRESHOLD, Sextante.getText((String)"Valor_umbral"), 10000.0, 2);
            this.addOutputRasterLayer(NETWORK, Sextante.getText((String)"Red_de_drenaje"));
            this.addOutputVectorLayer(NETWORKVECT, Sextante.getText((String)"Red_de_drenaje"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateChannelNetwork() throws UnsupportedOutputChannelException {
        ArrayList alHeaders = this.getHeaders();
        if (alHeaders != null) {
            this.m_HeadersAndJunctions = alHeaders;
            Object[] headers = alHeaders.toArray();
            Arrays.sort(headers);
            this.setProgressText(Sextante.getText((String)"Trazando_cauces"));
            if (headers.length > 0) {
                int i = 0;
                while (i < headers.length && this.setProgress(i, headers.length)) {
                    this.traceChannel((GridCell)headers[i]);
                    ++i;
                }
            }
            if (!this.m_Task.isCanceled()) {
                this.calculateOrderAndAddJunctions();
                this.createVectorLayer();
            }
        }
    }

    private ArrayList getHeaders() {
        ArrayList<GridCell> headers = new ArrayList<GridCell>();
        int y = 0;
        while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
            int x = 0;
            while (x < this.m_iNX) {
                double dValue = this.m_Threshold.getCellValueAsDouble(x, y);
                double dHeight1 = this.m_DEM.getCellValueAsDouble(x, y);
                if (this.meetsChannelConditions(dValue)) {
                    boolean bIsHeader = true;
                    dHeight1 = this.m_DEM.getCellValueAsDouble(x, y);
                    if (!this.m_DEM.isNoDataValue(dHeight1)) {
                        int iDirection = 0;
                        while (iDirection < 8) {
                            double dHeight2;
                            int ix = x + m_iOffsetX[iDirection];
                            int iy = y + m_iOffsetY[iDirection];
                            dValue = this.m_Threshold.getCellValueAsDouble(ix, iy);
                            if (this.meetsChannelConditions(dValue) && (dHeight2 = this.m_DEM.getCellValueAsDouble(ix, iy)) >= dHeight1) {
                                bIsHeader = false;
                                break;
                            }
                            ++iDirection;
                        }
                        if (bIsHeader) {
                            headers.add(new GridCell(x, y, this.m_DEM.getCellValueAsDouble(x, y)));
                        }
                    }
                }
                ++x;
            }
            ++y;
        }
        if (this.m_Task.isCanceled()) {
            return null;
        }
        return headers;
    }

    private boolean meetsChannelConditions(double dValue) {
        if (this.m_iMethod == 0) {
            return dValue > this.m_dThreshold;
        }
        if (this.m_iMethod == 1) {
            return dValue < this.m_dThreshold;
        }
        return false;
    }

    private void traceChannel(GridCell cell) {
        boolean bContinue = true;
        int x = cell.getX();
        int y = cell.getY();
        do {
            this.m_Network.setCellValue(x, y, -1.0);
            int iDirection = this.m_DEM.getDirToNextDownslopeCell(x, y);
            if (iDirection >= 0) {
                x += m_iOffsetX[iDirection];
                y += m_iOffsetY[iDirection];
                continue;
            }
            bContinue = false;
        } while (bContinue && !this.m_Task.isCanceled());
    }

    private void calculateOrderAndAddJunctions() {
        this.setProgressText(Sextante.getText((String)"Calculando_ordenes"));
        int y = 0;
        while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
            int x = 0;
            while (x < this.m_iNX) {
                this.getStrahlerOrder(x, y);
                ++x;
            }
            ++y;
        }
    }

    private int getStrahlerOrder(int x, int y) {
        int iMaxOrder = 1;
        int iOrder = 1;
        int iMaxOrderCells = 0;
        int iUpslopeChannelCells = 0;
        if (this.m_Network.getCellValueAsInt(x, y) == -1) {
            int i = 0;
            while (i < 8) {
                int ix = x + m_iOffsetX[i];
                int iy = y + m_iOffsetY[i];
                int iDirection = this.m_DEM.getDirToNextDownslopeCell(ix, iy);
                if (iDirection == (i + 4) % 8 && (iOrder = this.m_Network.getCellValueAsInt(ix, iy)) != 0) {
                    ++iUpslopeChannelCells;
                    iOrder = this.m_Network.getCellValueAsInt(ix, iy);
                    if (iOrder == -1) {
                        iOrder = this.getStrahlerOrder(ix, iy);
                    }
                    if (iOrder > iMaxOrder) {
                        iMaxOrder = iOrder;
                        iMaxOrderCells = 1;
                    } else if (iOrder == iMaxOrder) {
                        ++iMaxOrderCells;
                    }
                }
                ++i;
            }
            if (iMaxOrderCells > 1) {
                ++iMaxOrder;
            }
            if (iUpslopeChannelCells > 1) {
                this.m_HeadersAndJunctions.add(new GridCell(x, y, this.m_DEM.getCellValueAsDouble(x, y)));
            }
            this.m_Network.setCellValue(x, y, (double)iMaxOrder);
        }
        return iMaxOrder;
    }

    private void createVectorLayer() throws UnsupportedOutputChannelException {
        int iIndexDownslope = -1;
        GridExtent extent = this.m_DEM.getWindowGridExtent();
        Object[] values = new Object[4];
        String[] sNames = new String[]{Sextante.getText((String)"ID"), Sextante.getText((String)"Longitud"), Sextante.getText((String)"Orden"), Sextante.getText((String)"Siguiente")};
        Class[] types = new Class[]{Integer.class, Double.class, Integer.class, Integer.class};
        IVectorLayer network = this.getNewVectorLayer(NETWORKVECT, Sextante.getText((String)"Red_de_drenaje"), 1, types, sNames);
        Object[] headers = this.m_HeadersAndJunctions.toArray();
        Arrays.sort(headers);
        this.setProgressText(Sextante.getText((String)"Creando_red_vectorial"));
        int i = headers.length - 1;
        while (i > -1 && this.setProgress(headers.length - i, headers.length)) {
            GridCell cell = (GridCell)headers[i];
            int x = cell.getX();
            int y = cell.getY();
            ArrayList<Coordinate> coordsList = new ArrayList<Coordinate>();
            Point2D pt = extent.getWorldCoordsFromGridCoords(cell);
            coordsList.add(new Coordinate(pt.getX(), pt.getY()));
            double dLength = 0.0;
            int iOrder = this.m_Network.getCellValueAsInt(x, y);
            boolean bContinue = true;
            do {
                int iDirection;
                if ((iDirection = this.m_DEM.getDirToNextDownslopeCell(x, y)) >= 0) {
                    int ix = x + m_iOffsetX[iDirection];
                    int iy = y + m_iOffsetY[iDirection];
                    cell = new GridCell(ix, iy, this.m_DEM.getCellValueAsDouble(ix, iy));
                    pt = extent.getWorldCoordsFromGridCoords(cell);
                    coordsList.add(new Coordinate(pt.getX(), pt.getY()));
                    dLength += this.m_DEM.getDistToNeighborInDir(iDirection);
                    iIndexDownslope = this.m_HeadersAndJunctions.indexOf(cell);
                    if (iIndexDownslope != -1) {
                        bContinue = false;
                    }
                    x = ix;
                    y = iy;
                    continue;
                }
                bContinue = false;
            } while (bContinue && !this.m_Task.isCanceled());
            values[0] = new Integer(i);
            values[1] = new Double(dLength);
            values[2] = new Integer(iOrder);
            values[3] = new Integer(iIndexDownslope);
            Coordinate[] coords = new Coordinate[coordsList.size()];
            int j = 0;
            while (j < coords.length) {
                coords[j] = (Coordinate)coordsList.get(j);
                ++j;
            }
            LineString geom = new GeometryFactory().createLineString(coords);
            network.addFeature((Geometry)geom, values);
            --i;
        }
    }
}

