/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.createHyetogram;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.hydrology.modelling.Hyetograph;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CreateHyetogramAlgorithm
extends GeoAlgorithm {
    public static final String RETURNS = "RETURNS";
    public static final String HYETOGRAPHLENGTH = "HYETOGRAPHLENGTH";
    public static final String TIMETOPEAK = "TIMETOPEAK";
    public static final String INTERVAL = "INTERVAL";
    public static final String AVERAGE = "AVERAGE";
    public static final String STDDEV = "STDDEV";
    public static final String HYETOGRAPH = "HYETOGRAPH";
    private int m_iInterval;
    private int m_iPeakTime;
    private int m_iHyetoLength;
    private int m_iRatioI1 = 10;
    private ArrayList m_Returns;
    private double m_dMean;
    private double m_dStdDev;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_iInterval = this.m_Parameters.getParameterValueAsInt(INTERVAL) * 60;
        this.m_iHyetoLength = this.m_Parameters.getParameterValueAsInt(HYETOGRAPHLENGTH) * 60;
        this.m_iPeakTime = this.m_Parameters.getParameterValueAsInt(TIMETOPEAK) * 60;
        this.m_dMean = this.m_Parameters.getParameterValueAsDouble(AVERAGE);
        this.m_dStdDev = this.m_Parameters.getParameterValueAsDouble(STDDEV);
        this.m_Returns = new ArrayList();
        String sReturns = this.m_Parameters.getParameterValueAsString(RETURNS);
        StringTokenizer st = new StringTokenizer(sReturns);
        while (st.hasMoreTokens()) {
            try {
                String token = st.nextToken();
                Integer value = Integer.valueOf(token);
                this.m_Returns.add(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.createTable();
        return true;
    }

    private void createTable() throws UnsupportedOutputChannelException {
        String[] sFields = new String[this.m_Returns.size() + 1];
        Object[] values = new Object[this.m_Returns.size() + 1];
        Class[] types = new Class[this.m_Returns.size() + 1];
        Hyetograph[] hyetos = new Hyetograph[this.m_Returns.size()];
        types[0] = Double.class;
        sFields[0] = "T";
        int i = 0;
        while (i < this.m_Returns.size()) {
            types[i + 1] = Double.class;
            sFields[i + 1] = "P_" + ((Integer)this.m_Returns.get(i)).toString();
            ++i;
        }
        ITable driver = this.getNewTable(HYETOGRAPH, Sextante.getText((String)"Hietograma"), types, sFields);
        i = 0;
        while (i < this.m_Returns.size()) {
            int iReturn = (Integer)this.m_Returns.get(i);
            hyetos[i] = this.getHyetograph(iReturn);
            ++i;
        }
        int j = 0;
        while (j < hyetos[0].getIntervals()) {
            values[0] = new Double(j * hyetos[0].getTimeInterval());
            int k = 0;
            while (k < hyetos.length) {
                values[k + 1] = new Double(hyetos[k].getRainfallAtInterval(j));
                ++k;
            }
            driver.addRecord(values);
            ++j;
        }
    }

    private Hyetograph getHyetograph(int iReturn) {
        double dAlpha = Math.sqrt(Math.pow(3.141592, 2.0) / 6.0 / this.m_dStdDev);
        double dMu = this.m_dMean - 0.5772 / dAlpha;
        double dFx = 1.0 - 1.0 / (double)iReturn;
        double dP24 = (float)(-Math.log(Math.log(1.0 / dFx)));
        dP24 = dP24 / dAlpha + dMu;
        return new Hyetograph(dP24, this.m_iHyetoLength, this.m_iInterval, this.m_iPeakTime, iReturn, this.m_iRatioI1);
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Crear_hietogramas"));
        this.setGroup(Sextante.getText((String)"Indices_y_otros_parametros_hidrologicos"));
        this.setGeneratesUserDefinedRasterOutput(false);
        try {
            this.m_Parameters.addString(RETURNS, Sextante.getText((String)"Periodos_retorno"), "5 10 25 50 100");
            this.m_Parameters.addNumericalValue(HYETOGRAPHLENGTH, Sextante.getText((String)"Duracion_minutos"), 1, 180.0, -2.147483648E9, 2.147483647E9);
            this.m_Parameters.addNumericalValue(TIMETOPEAK, Sextante.getText((String)"Tiempo_al_pico_minutos"), 1, 120.0, -2.147483648E9, 2.147483647E9);
            this.m_Parameters.addNumericalValue(INTERVAL, Sextante.getText((String)"Intervalo_minutos"), 1, 10.0, 1.0, 2.147483647E9);
            this.m_Parameters.addNumericalValue(AVERAGE, Sextante.getText((String)"Media_precipitacion"), 2, 0.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(STDDEV, Sextante.getText((String)"Desviacion_precipitacion"), 2, 0.0, 0.0, Double.MAX_VALUE);
            this.addOutputTable(HYETOGRAPH, Sextante.getText((String)"Hietograma"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

