/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.distToChannelNetwork;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import es.unex.sextante.rasterWrappers.GridExtent;
import java.util.ArrayList;

public class DistToChannelNetworkAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX;
    private static final int[] m_iOffsetY;
    public static final String DEM = "DEM";
    public static final String NETWORK = "NETWORK";
    public static final String DIST = "DIST";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Network = null;
    private IRasterLayer m_Dist;
    private IRasterLayer m_Directions;
    private ArrayList m_AdjPoints;
    private ArrayList m_CentralPoints;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        m_iOffsetX = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        m_iOffsetY = nArray2;
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Network = this.m_Parameters.getParameterValueAsRasterLayer(NETWORK);
        this.m_Dist = this.getNewRasterLayer(DIST, Sextante.getText((String)"Distancia_a_red_de_drenaje"), 5, this.m_DEM);
        this.m_Dist.setNoDataValue(-1.0);
        this.m_Dist.assignNoData();
        GridExtent extent = this.m_Dist.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        this.m_Network.setWindowExtent(extent);
        this.m_Network.setInterpolationMethod(0);
        this.m_Directions = this.getTempRasterLayer(3, extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.prepareInitData();
        this.calculateDistance();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Distancia_a_red_de_drenaje"));
        this.setGroup(Sextante.getText((String)"Indices_y_otros_parametros_hidrologicos"));
        this.setGeneratesUserDefinedRasterOutput(true);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.m_Parameters.addInputRasterLayer(NETWORK, Sextante.getText((String)"Red_de_drenaje"), true);
            this.addOutputRasterLayer(DIST, Sextante.getText((String)"Distancia_a_red_de_drenaje"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void prepareInitData() {
        this.m_AdjPoints = new ArrayList();
        this.m_CentralPoints = new ArrayList();
        int y = 0;
        while (y < this.m_iNY) {
            int x = 0;
            while (x < this.m_iNX) {
                int iDir = this.m_DEM.getDirToNextDownslopeCell(x, y, false);
                int iChannel = this.m_Network.getCellValueAsInt(x, y);
                if (iDir < 0) {
                    this.m_Directions.setCellValue(x, y, -1.0);
                } else {
                    this.m_Directions.setCellValue(x, y, (double)((iDir + 4) % 8));
                }
                if (iChannel != 0 && !this.m_Network.isNoDataValue((double)iChannel)) {
                    this.m_Dist.setCellValue(x, y, 0.0);
                    this.m_CentralPoints.add(new GridCell(x, y, 0.0));
                }
                ++x;
            }
            ++y;
        }
    }

    private void calculateDistance() {
        while (this.m_CentralPoints.size() != 0) {
            int iPt = 0;
            while (iPt < this.m_CentralPoints.size()) {
                GridCell cell = (GridCell)this.m_CentralPoints.get(iPt);
                int x = cell.getX();
                int y = cell.getY();
                double dDist = this.m_Dist.getCellValueAsDouble(x, y);
                int i = 0;
                while (i < 8) {
                    int x2 = x + m_iOffsetX[i];
                    int y2 = y + m_iOffsetY[i];
                    if (this.m_Directions.getCellValueAsInt(x2, y2) == i) {
                        double dAccDist = dDist + this.m_DEM.getDistToNeighborInDir(i);
                        double dDist2 = this.m_Dist.getCellValueAsDouble(x2, y2);
                        if (this.m_Dist.isNoDataValue(dDist2) || dDist2 > dAccDist) {
                            this.m_Dist.setCellValue(x2, y2, dAccDist);
                            this.m_AdjPoints.add(new GridCell(x2, y2, 0.0));
                        }
                    }
                    ++i;
                }
                ++iPt;
            }
            this.m_CentralPoints = this.m_AdjPoints;
            this.m_AdjPoints = new ArrayList();
            if (!this.m_Task.isCanceled()) continue;
            return;
        }
    }
}

