/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.edgeContamination;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.hydrology.accFlow.AccFlowAlgorithm;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.rasterWrappers.GridExtent;

public class EdgeContaminationAlgorithm
extends GeoAlgorithm {
    public static final String EDGECONT = "EDGECONT";
    public static final String DEM = "DEM";
    private int m_iNX;
    private int m_iNY;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer dem = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        IRasterLayer weights = this.getTempRasterLayer(0, new GridExtent((ILayer)dem));
        weights.assign(0.0);
        this.m_iNX = weights.getWindowGridExtent().getNX();
        this.m_iNY = weights.getWindowGridExtent().getNY();
        int y = 0;
        while (y < this.m_iNY) {
            weights.setCellValue(1, y, 1.0);
            weights.setCellValue(this.m_iNX - 2, y, 1.0);
            ++y;
        }
        int x = 0;
        while (x < this.m_iNX) {
            weights.setCellValue(x, 1, 1.0);
            weights.setCellValue(x, this.m_iNY - 2, 1.0);
            ++x;
        }
        AccFlowAlgorithm alg = new AccFlowAlgorithm();
        ParametersSet ps = alg.getParameters();
        ps.getParameter("WEIGHTS").setParameterValue((Object)weights);
        ps.getParameter(DEM).setParameterValue((Object)dem);
        ps.getParameter("METHOD").setParameterValue((Object)new Integer(3));
        Output flowacc = alg.getOutputObjects().getOutput("FLOWACC");
        flowacc.setOutputChannel(this.getOutputChannel(EDGECONT));
        if (!alg.execute(this.m_Task, this.m_OutputFactory)) {
            return false;
        }
        Output out = this.m_OutputObjects.getOutput(EDGECONT);
        out.setOutputObject(flowacc.getOutputObject());
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Contaminacion_de_borde"));
        this.setGroup(Sextante.getText((String)"Indices_y_otros_parametros_hidrologicos"));
        this.setGeneratesUserDefinedRasterOutput(false);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.addOutputRasterLayer(EDGECONT, Sextante.getText((String)"Contaminacion_de_borde"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

