/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.fillSinks;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridExtent;

public class FillSinksAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX;
    private static final int[] m_iOffsetY;
    private static final double INIT_ELEVATION = 50000.0;
    public static final String DEM = "DEM";
    public static final String MINSLOPE = "MINSLOPE";
    public static final String RESULT = "RESULT";
    private int depth;
    private int m_iNX;
    private int m_iNY;
    private double[] dEpsilon = new double[8];
    private int R;
    private int C;
    private int[] R0 = new int[8];
    private int[] C0 = new int[8];
    private int[] dR = new int[8];
    private int[] dC = new int[8];
    private int[] fR = new int[8];
    private int[] fC = new int[8];
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Border;
    private IRasterLayer m_PreprocessedDEM;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        m_iOffsetX = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        m_iOffsetY = nArray2;
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Eliminar_depresiones"));
        this.setGroup(Sextante.getText((String)"Analisis_hidrologico_basico"));
        super.setGeneratesUserDefinedRasterOutput(false);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.m_Parameters.addNumericalValue(MINSLOPE, Sextante.getText((String)"Angulo_minimo_entre_celdas"), 0.01, 2);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Preprocesado"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        boolean something_done = false;
        this.depth = 0;
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        double dMinSlope = Math.tan(Math.toRadians(this.m_Parameters.getParameterValueAsDouble(MINSLOPE)));
        GridExtent ge = new GridExtent((ILayer)this.m_DEM);
        this.m_PreprocessedDEM = this.getNewRasterLayer(RESULT, String.valueOf(this.m_DEM.getName()) + Sextante.getText((String)"preprocesado_corchetes"), 5, ge);
        this.m_Border = this.getTempRasterLayer(3, ge);
        this.m_DEM.setFullExtent();
        this.m_iNX = ge.getNX();
        this.m_iNY = ge.getNY();
        int i = 0;
        while (i < 8) {
            this.dEpsilon[i] = dMinSlope * this.m_DEM.getDistToNeighborInDir(i);
            ++i;
        }
        this.R0[0] = 0;
        this.R0[1] = this.m_iNY - 1;
        this.R0[2] = 0;
        this.R0[3] = this.m_iNY - 1;
        this.R0[4] = 0;
        this.R0[5] = this.m_iNY - 1;
        this.R0[6] = 0;
        this.R0[7] = this.m_iNY - 1;
        this.C0[0] = 0;
        this.C0[1] = this.m_iNX - 1;
        this.C0[2] = this.m_iNX - 1;
        this.C0[3] = 0;
        this.C0[4] = this.m_iNX - 1;
        this.C0[5] = 0;
        this.C0[6] = 0;
        this.C0[7] = this.m_iNX - 1;
        this.dR[0] = 0;
        this.dR[1] = 0;
        this.dR[2] = 1;
        this.dR[3] = -1;
        this.dR[4] = 0;
        this.dR[5] = 0;
        this.dR[6] = 1;
        this.dR[7] = -1;
        this.dC[0] = 1;
        this.dC[1] = -1;
        this.dC[2] = 0;
        this.dC[3] = 0;
        this.dC[4] = -1;
        this.dC[5] = 1;
        this.dC[6] = 0;
        this.dC[7] = 0;
        this.fR[0] = 1;
        this.fR[1] = -1;
        this.fR[2] = -this.m_iNY + 1;
        this.fR[3] = this.m_iNY - 1;
        this.fR[4] = 1;
        this.fR[5] = -1;
        this.fR[6] = -this.m_iNY + 1;
        this.fR[7] = this.m_iNY - 1;
        this.fC[0] = -this.m_iNX + 1;
        this.fC[1] = this.m_iNX - 1;
        this.fC[2] = -1;
        this.fC[3] = 1;
        this.fC[4] = this.m_iNX - 1;
        this.fC[5] = -this.m_iNX + 1;
        this.fC[6] = 1;
        this.fC[7] = -1;
        this.initAltitude();
        this.setProgressText("Fase 1");
        int x = 0;
        while (x < this.m_iNX && this.setProgress(x, this.m_iNX)) {
            int y = 0;
            while (y < this.m_iNY) {
                int iValue = this.m_Border.getCellValueAsInt(x, y);
                if (iValue == 1) {
                    this.dryUpwardCell(x, y);
                }
                ++y;
            }
            ++x;
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        int it = 0;
        while (it < 1000) {
            this.setProgressText("fase 2. Iteracion " + Integer.toString(it));
            int scan = 0;
            while (scan < 8) {
                this.R = this.R0[scan];
                this.C = this.C0[scan];
                something_done = false;
                if (!this.setProgress(scan, 8)) {
                    return false;
                }
                block5: do {
                    double z = this.m_DEM.getCellValueAsDouble(this.C, this.R);
                    double wz = this.m_PreprocessedDEM.getCellValueAsDouble(this.C, this.R);
                    if (this.m_DEM.isNoDataValue(z) || !(wz > z)) continue;
                    i = 0;
                    while (i < 8) {
                        int ix = this.C + m_iOffsetX[i];
                        int iy = this.R + m_iOffsetY[i];
                        double z2 = this.m_DEM.getCellValueAsDouble(ix, iy);
                        if (!this.m_DEM.isNoDataValue(z2)) {
                            double wzn = this.m_PreprocessedDEM.getCellValueAsDouble(ix, iy) + this.dEpsilon[i];
                            if (z >= wzn) {
                                this.m_PreprocessedDEM.setCellValue(this.C, this.R, z);
                                something_done = true;
                                this.dryUpwardCell(this.C, this.R);
                                continue block5;
                            }
                            if (wz > wzn) {
                                this.m_PreprocessedDEM.setCellValue(this.C, this.R, wzn);
                                something_done = true;
                            }
                        }
                        ++i;
                    }
                } while (this.nextCell(scan));
                if (!something_done) break;
                ++scan;
            }
            if (!something_done) break;
            ++it;
        }
        return !this.m_Task.isCanceled();
    }

    private boolean nextCell(int i) {
        this.R += this.dR[i];
        this.C += this.dC[i];
        if (this.R < 0 || this.C < 0 || this.R >= this.m_iNY || this.C >= this.m_iNX) {
            this.R += this.fR[i];
            this.C += this.fC[i];
            if (this.R < 0 || this.C < 0 || this.R >= this.m_iNY || this.C >= this.m_iNX) {
                return false;
            }
        }
        return true;
    }

    private void dryUpwardCell(int x, int y) {
        int MAX_DEPTH = 32000;
        ++this.depth;
        if (this.depth <= 32000) {
            int i = 0;
            while (i < 8) {
                int ix = x + m_iOffsetX[i];
                int iy = y + m_iOffsetY[i];
                double zw = this.m_PreprocessedDEM.getCellValueAsDouble(ix, iy);
                double zn = this.m_DEM.getCellValueAsDouble(ix, iy);
                if (!this.m_DEM.isNoDataValue(zn) && zw == 50000.0 && zn >= (zw = this.m_PreprocessedDEM.getCellValueAsDouble(x, y) + this.dEpsilon[i])) {
                    this.m_PreprocessedDEM.setCellValue(ix, iy, zn);
                    this.dryUpwardCell(ix, iy);
                }
                ++i;
            }
        }
        --this.depth;
    }

    private void initAltitude() {
        this.m_Border.assignNoData();
        this.m_PreprocessedDEM.assignNoData();
        int x = 0;
        while (x < this.m_iNX) {
            int y = 0;
            while (y < this.m_iNY) {
                boolean border = false;
                double dValue = this.m_DEM.getCellValueAsDouble(x, y);
                if (!this.m_DEM.isNoDataValue(dValue)) {
                    int i = 0;
                    while (i < 8) {
                        int ix = x + m_iOffsetX[i];
                        int iy = y + m_iOffsetY[i];
                        dValue = this.m_DEM.getCellValueAsDouble(ix, iy);
                        if (this.m_DEM.isNoDataValue(dValue)) {
                            border = true;
                            break;
                        }
                        ++i;
                    }
                    if (border) {
                        this.m_Border.setCellValue(x, y, 1.0);
                        this.m_PreprocessedDEM.setCellValue(x, y, this.m_DEM.getCellValueAsDouble(x, y));
                    } else {
                        this.m_PreprocessedDEM.setCellValue(x, y, 50000.0);
                    }
                }
                ++y;
            }
            ++x;
        }
    }
}

