/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.guh;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;

public class GUHAlgorithm
extends GeoAlgorithm {
    private static int lgfN = 6;
    private static double[] lgfCoeff = new double[]{1.000000000190015, 76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static double lgfGamma = 5.0;
    private Stream[] m_Streams;
    private double m_dRB;
    private double m_dRA;
    private double m_dRL;
    private double m_dMaxLength;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.calculateStreamParameters();
        this.calculateGUH();
        return !this.m_Task.isCanceled();
    }

    private void calculateGUH() throws GeoAlgorithmExecutionException {
        double dH;
        double dTime = 0.0;
        int iCount = 0;
        double dInterval = this.m_Parameters.getParameterValueAsDouble("INTERVAL") / 60.0;
        double dVelocity = this.m_Parameters.getParameterValueAsDouble("VELOCITY");
        Object[] values = new Object[2];
        String[] sFields = new String[]{"t", "h(t)"};
        Class[] iTypes = new Class[]{Double.class, Double.class};
        ITable table = this.getNewTable("GUH", Sextante.getText((String)"GUH"), iTypes, sFields);
        double dN = 3.29 * Math.pow(this.m_dRB / this.m_dRA, 0.78) * Math.pow(this.m_dRL, 0.07);
        double dK = 0.7 * Math.pow(this.m_dRA / (this.m_dRB * this.m_dRL), 0.48) * this.m_dMaxLength / dVelocity;
        do {
            dH = 1.0 / dK / this.gammaFunction(dN);
            dH *= Math.pow(dTime / dK, dN - 1.0);
            values[0] = new Double(dTime);
            values[1] = new Double(dH *= Math.exp(dTime / dK));
            table.addRecord(values);
            dTime += dInterval;
        } while (dH > 1.0E-6 || ++iCount < 20);
    }

    private void calculateStreamParameters() throws GeoAlgorithmExecutionException {
        int iMaxOrder = 0;
        this.createStreamData();
        int i = 0;
        while (i < this.m_Streams.length) {
            iMaxOrder = Math.max(iMaxOrder, this.m_Streams[i].iOrder);
            ++i;
        }
        double[] dLength = new double[iMaxOrder];
        double[] dArea = new double[iMaxOrder];
        int[] iCount = new int[iMaxOrder];
        int i2 = 0;
        while (i2 < this.m_Streams.length) {
            if (this.m_Streams[i2].dArea != 0.0) {
                int iOrder;
                int n = iOrder = this.m_Streams[i2].iOrder - 1;
                iCount[n] = iCount[n] + 1;
                int n2 = iOrder;
                dArea[n2] = dArea[n2] + this.m_Streams[i2].dArea;
                int n3 = iOrder;
                dLength[n3] = dLength[n3] + this.m_Streams[i2].dLength;
            }
            ++i2;
        }
        this.m_dRL = 0.0;
        this.m_dRB = 0.0;
        this.m_dRA = 0.0;
        i2 = 0;
        while (i2 < iMaxOrder) {
            int n = i2;
            dArea[n] = dArea[n] / (double)iCount[i2];
            int n4 = i2;
            dLength[n4] = dLength[n4] / (double)iCount[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < iMaxOrder - 1) {
            this.m_dRB += (double)iCount[i2] / (double)iCount[i2 + 1];
            this.m_dRA += dArea[i2] / dArea[i2 + 1];
            this.m_dRL += dLength[i2] / dLength[i2 + 1];
            ++i2;
        }
        this.m_dRB /= (double)(iMaxOrder - 1);
        this.m_dRL /= (double)(iMaxOrder - 1);
        this.m_dRA /= (double)(iMaxOrder - 1);
        this.calculateMaxLength();
    }

    private void calculateMaxLength() {
        this.m_dMaxLength = 0.0;
        int i = 0;
        while (i < this.m_Streams.length) {
            double dLength = this.m_Streams[i].dLength;
            int iNext = this.m_Streams[i].iDownslope;
            while (iNext != -1) {
                dLength += this.m_Streams[iNext].dLength;
                iNext = this.m_Streams[iNext].iDownslope;
            }
            this.m_dMaxLength = Math.max(this.m_dMaxLength, dLength);
            ++i;
        }
        this.m_dMaxLength /= 1000.0;
    }

    private void createStreamData() throws GeoAlgorithmExecutionException {
        GeometryFactory gf = new GeometryFactory();
        double[] data = new double[6];
        IVectorLayer streamsLyr = this.m_Parameters.getParameterValueAsVectorLayer("STREAMS");
        IVectorLayer basinsLyr = this.m_Parameters.getParameterValueAsVectorLayer("BASINS");
        int iFieldArea = this.m_Parameters.getParameterValueAsInt("AREA");
        int iFieldOrder = this.m_Parameters.getParameterValueAsInt("ORDER");
        int iFieldLength = this.m_Parameters.getParameterValueAsInt("LENGTH");
        int iFieldDownslope = this.m_Parameters.getParameterValueAsInt("DOWNSLOPE");
        if (streamsLyr.getShapesCount() == 0) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Capa_de_cauces_no_contiene_elementos"));
        }
        if (basinsLyr.getShapesCount() == 0) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Capa_de_cuencas_no_contiene_elementos"));
        }
        this.m_Streams = new Stream[streamsLyr.getShapesCount()];
        boolean[] bBasinUsed = new boolean[basinsLyr.getShapesCount()];
        IFeatureIterator iter = streamsLyr.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IFeature feature = iter.next();
            boolean bSkipStream = false;
            try {
                this.m_Streams[i] = new Stream();
                this.m_Streams[i].iOrder = Integer.parseInt(feature.getRecord().getValue(iFieldOrder).toString());
                this.m_Streams[i].dLength = Double.parseDouble(feature.getRecord().getValue(iFieldLength).toString());
                this.m_Streams[i].iDownslope = Integer.parseInt(feature.getRecord().getValue(iFieldDownslope).toString());
            }
            catch (NumberFormatException e) {
                throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Valores_erroneos_en_capa_cauces"));
            }
            Geometry stream = feature.getGeometry().getGeometryN(0);
            Coordinate[] coords = stream.getCoordinates();
            if (coords.length > 5) {
                Coordinate coord1 = coords[(int)((double)coords.length / 2.0 - 1.0)];
                Coordinate coord2 = coords[(int)((double)coords.length / 2.0)];
                Coordinate centerCoord = new Coordinate((coord1.x + coord2.x) / 2.0, (coord1.y + coord2.y) / 2.0);
                IFeatureIterator iterBasins = basinsLyr.iterator();
                int j = 0;
                while (iterBasins.hasNext()) {
                    Geometry basin;
                    IFeature featureBasin = iterBasins.next();
                    if (!bBasinUsed[j] && (basin = feature.getGeometry().getGeometryN(0)).contains((Geometry)gf.createPoint(centerCoord))) {
                        bBasinUsed[j] = true;
                        this.m_Streams[i].dArea = Double.parseDouble(featureBasin.getRecord().getValue(iFieldArea).toString());
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"GUH"));
        this.setGroup(Sextante.getText((String)"Indices_y_otros_parametros_hidrologicos"));
        this.setGeneratesUserDefinedRasterOutput(false);
        try {
            this.addOutputTable("GUH", Sextante.getText((String)"GUH"));
            this.m_Parameters.addInputVectorLayer("STREAMS", Sextante.getText((String)"Red_de_drenaje"), 1, true);
            this.m_Parameters.addTableField("ORDER", Sextante.getText((String)"Orden"), "STREAMS");
            this.m_Parameters.addTableField("LENGTH", Sextante.getText((String)"Longitud"), "STREAMS");
            this.m_Parameters.addTableField("DOWNSLOPE", Sextante.getText((String)"Tramo_aguas_abajo"), "STREAMS");
            this.m_Parameters.addInputVectorLayer("BASINS", Sextante.getText((String)"Cuencas"), 2, true);
            this.m_Parameters.addTableField("AREA", Sextante.getText((String)"Area"), "BASINS");
            this.m_Parameters.addNumericalValue("VELOCITY", Sextante.getText((String)"velocidad_media_guh"), 5.0, 2);
            this.m_Parameters.addNumericalValue("INTERVAL", Sextante.getText((String)"Intervalo_minutos"), 5.0, 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private double gammaFunction(double x) {
        double xcopy = x;
        double first = x + lgfGamma + 0.5;
        double second = lgfCoeff[0];
        double fg = 0.0;
        if (x >= 0.0) {
            if (x >= 1.0 && x - (double)((int)x) == 0.0) {
                fg = this.factorial(x) / x;
            } else {
                first = Math.pow(first, x + 0.5) * Math.exp(-first);
                int i = 1;
                while (i <= lgfN) {
                    second += lgfCoeff[i] / (xcopy += 1.0);
                    ++i;
                }
                fg = first * Math.sqrt(Math.PI * 2) * second / x;
            }
        } else {
            fg = -Math.PI / (x * this.gammaFunction(-x) * Math.sin(Math.PI * x));
        }
        return fg;
    }

    private double factorial(double n) {
        double f = 1.0;
        double iCount = 2.0;
        while (iCount <= n) {
            f *= iCount;
            iCount += 1.0;
        }
        return f;
    }

    private class Stream {
        public int iOrder;
        public double dArea = 0.0;
        public double dLength;
        public int iDownslope;

        private Stream() {
        }
    }
}

