/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.heightOverChannelNetwork;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.gridTools.closeGaps.CloseGapsAlgorithm;
import es.unex.sextante.rasterWrappers.GridExtent;

public class HeightOverChannelNetworkAlgorithm
extends GeoAlgorithm {
    public static final String DEM = "DEM";
    public static final String NETWORK = "NETWORK";
    public static final String HEIGHTOVER = "HEIGHTOVER";
    public static final String THRESHOLD = "THRESHOLD";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Network = null;
    private IRasterLayer m_Diff;
    private double m_dThreshold;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Network = this.m_Parameters.getParameterValueAsRasterLayer(NETWORK);
        this.m_dThreshold = this.m_Parameters.getParameterValueAsDouble(THRESHOLD);
        this.m_Diff = this.getNewRasterLayer(HEIGHTOVER, Sextante.getText((String)"Elevacion_sobre_la_red_de_drenaje"), 4, this.m_DEM);
        this.m_Diff.setNoDataValue(-1.0);
        GridExtent extent = this.m_Diff.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        this.m_Network.setWindowExtent(extent);
        this.m_Network.setInterpolationMethod(0);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        return this.interpolateSurfaceAndSubstract();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Elevacion_sobre_la_red_de_drenaje"));
        this.setGroup(Sextante.getText((String)"Indices_y_otros_parametros_hidrologicos"));
        this.setGeneratesUserDefinedRasterOutput(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.m_Parameters.addInputRasterLayer(NETWORK, Sextante.getText((String)"Red_de_drenaje"), true);
            this.m_Parameters.addNumericalValue(THRESHOLD, Sextante.getText((String)"Umbral_de_tension"), 0.1, 2);
            this.addOutputRasterLayer(HEIGHTOVER, Sextante.getText((String)"Elevacion_sobre_la_red_de_drenaje"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private boolean interpolateSurfaceAndSubstract() throws GeoAlgorithmExecutionException {
        double dValue;
        int x;
        int y = 0;
        while (y < this.m_iNY) {
            x = 0;
            while (x < this.m_iNX) {
                dValue = this.m_Network.getCellValueAsDouble(x, y);
                if (dValue != 0.0 && !this.m_Network.isNoDataValue(dValue)) {
                    dValue = this.m_DEM.getCellValueAsDouble(x, y);
                    this.m_Diff.setCellValue(x, y, dValue);
                } else {
                    this.m_Diff.setNoData(x, y);
                }
                ++x;
            }
            ++y;
        }
        CloseGapsAlgorithm alg = new CloseGapsAlgorithm();
        ParametersSet ps = alg.getParameters();
        ps.getParameter("INPUT").setParameterValue((Object)this.m_Diff);
        ps.getParameter(THRESHOLD).setParameterValue((Object)new Double(this.m_dThreshold));
        if (alg.execute(this.m_Task, this.m_OutputFactory)) {
            OutputObjectsSet output = alg.getOutputObjects();
            IRasterLayer networkHeight = (IRasterLayer)output.getOutput("RESULT").getOutputObject();
            networkHeight.open();
            y = 0;
            while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
                x = 0;
                while (x < this.m_iNX) {
                    dValue = this.m_DEM.getCellValueAsDouble(x, y);
                    double dValue2 = networkHeight.getCellValueAsDouble(x, y);
                    if (this.m_DEM.isNoDataValue(dValue) || networkHeight.isNoDataValue(dValue2)) {
                        this.m_Diff.setNoData(x, y);
                    } else {
                        this.m_Diff.setCellValue(x, y, dValue - dValue2);
                    }
                    ++x;
                }
                ++y;
            }
            networkHeight.close();
            return !this.m_Task.isCanceled();
        }
        return false;
    }
}

