/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.hydroModel;

import com.vividsolutions.jts.geom.Coordinate;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IRecordsetIterator;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.hydrology.modelling.Hydrograph;
import es.unex.sextante.hydrology.modelling.Hyetograph;
import es.unex.sextante.rasterWrappers.GridExtent;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class HydroModelAlgorithm
extends GeoAlgorithm {
    public static final String TABLES = "TABLES";
    public static final String TIMEOUT = "TIMEOUT";
    public static final String CN = "CN";
    public static final String INTERVALHYDRO = "INTERVALHYDRO";
    public static final String INTERVALHYETO = "INTERVALHYETO";
    public static final String FIELD = "FIELD";
    public static final String STATIONS = "STATIONS";
    private int m_iNX;
    private int m_iNY;
    private int m_iIntervalHydro;
    private int m_iIntervalHyeto;
    private IRasterLayer m_TimeOut = null;
    private IRasterLayer m_CN = null;
    private ArrayList m_Hydrographs;
    private Hyetograph[][] m_Hyetogram;
    private ArrayList m_Tables;
    private int m_iTableNameField;
    private boolean m_bHyetoNamesCreated = false;
    private String[] m_sHyetoNames;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_TimeOut = this.m_Parameters.getParameterValueAsRasterLayer(TIMEOUT);
        this.m_CN = this.m_Parameters.getParameterValueAsRasterLayer(CN);
        this.m_iIntervalHydro = this.m_Parameters.getParameterValueAsInt(INTERVALHYDRO) * 60;
        this.m_iIntervalHyeto = this.m_Parameters.getParameterValueAsInt(INTERVALHYETO) * 60;
        this.m_iTableNameField = this.m_Parameters.getParameterValueAsInt(FIELD);
        this.m_TimeOut.setFullExtent();
        this.m_CN.setWindowExtent(this.m_TimeOut.getWindowGridExtent());
        this.m_iNX = this.m_TimeOut.getNX();
        this.m_iNY = this.m_TimeOut.getNY();
        if (!this.createHyetographs()) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Hietogramas_inconsistentes"));
        }
        this.calculateHydrographs();
        this.documentHydrographs();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Un_modelo_hidrologico"));
        this.setGroup(Sextante.getText((String)"Indices_y_otros_parametros_hidrologicos"));
        this.setGeneratesUserDefinedRasterOutput(false);
        try {
            this.m_Parameters.addInputRasterLayer(TIMEOUT, Sextante.getText((String)"Tiempo_de_salida"), true);
            this.m_Parameters.addInputRasterLayer(CN, Sextante.getText((String)"Numero_curva"), true);
            this.m_Parameters.addInputVectorLayer(STATIONS, Sextante.getText((String)"Estaciones"), 0, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Nombre_tabla_hieto"), STATIONS);
            this.m_Parameters.addMultipleInput(TABLES, Sextante.getText((String)"Tablas"), 6, true);
            this.m_Parameters.addNumericalValue(INTERVALHYDRO, Sextante.getText((String)"Intervalo_hidrogramas_min"), 1, 10.0, 1.0, 2.147483647E9);
            this.m_Parameters.addNumericalValue(INTERVALHYETO, Sextante.getText((String)"Intervalo_hietogramas_min"), 1, 30.0, 1.0, 2.147483647E9);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private boolean createHyetographs() {
        int iPoint = 0;
        try {
            IVectorLayer stations = this.m_Parameters.getParameterValueAsVectorLayer(STATIONS);
            this.m_Hyetogram = new Hyetograph[stations.getShapesCount()][];
            IFeatureIterator iter = stations.iterator();
            while (iter.hasNext()) {
                IFeature feature = iter.next();
                String sTableName = feature.getRecord().getValue(this.m_iTableNameField).toString();
                Coordinate c = feature.getGeometry().getCoordinate();
                this.m_Hyetogram[iPoint] = this.getHyetogramsFromTable(c.x, c.y, sTableName);
                ++iPoint;
            }
            iter.close();
            return this.checkHyetogramsConsistency();
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkHyetogramsConsistency() {
        try {
            int iIntervals = this.m_Hyetogram[0][0].getIntervals();
            int i = 0;
            block2: while (true) {
                if (i >= this.m_Hyetogram.length) {
                    return true;
                }
                if (iIntervals != this.m_Hyetogram[i][0].getIntervals()) {
                    return false;
                }
                int j = 0;
                while (true) {
                    if (j >= this.m_Hyetogram.length) {
                        ++i;
                        continue block2;
                    }
                    if (this.m_Hyetogram[j][i] == null) {
                        return false;
                    }
                    ++j;
                }
                break;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    private Hyetograph[] getHyetogramsFromTable(double x, double y, String sName) {
        block9: {
            int iCount;
            ITable table;
            block10: {
                table = this.getTableFromName(sName);
                if (table == null) break block9;
                iCount = table.getFieldCount() - 1;
                if (iCount >= 0) break block10;
                return null;
            }
            try {
                if (!this.m_bHyetoNamesCreated) {
                    this.m_bHyetoNamesCreated = true;
                    this.m_sHyetoNames = new String[iCount];
                    int i = 0;
                    while (i < iCount) {
                        this.m_sHyetoNames[i] = table.getFieldName(i + 1);
                        ++i;
                    }
                }
                Hyetograph[] hyetos = new Hyetograph[iCount];
                int i = 0;
                while (i < iCount) {
                    double[] dHyeto = new double[(int)table.getRecordCount()];
                    IRecordsetIterator iter = table.iterator();
                    int j = 0;
                    while (iter.hasNext()) {
                        IRecord record = iter.next();
                        String s = record.getValue(i + 1).toString();
                        s = s.replaceAll("'", "");
                        try {
                            dHyeto[j] = Double.parseDouble(s);
                        }
                        catch (NumberFormatException nfe) {
                            dHyeto[j] = 0.0;
                        }
                        ++j;
                    }
                    hyetos[i] = new Hyetograph(dHyeto, this.m_iIntervalHyeto);
                    hyetos[i].setName(String.valueOf(sName) + table.getFieldName(i + 1));
                    hyetos[i].setCoords(new Point2D.Double(x, y));
                    ++i;
                }
                return hyetos;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private ITable getTableFromName(String sName) {
        int i = 0;
        while (i < this.m_Tables.size()) {
            ITable table = (ITable)this.m_Tables.get(i);
            if (table.getName().equals(sName)) {
                return table;
            }
            ++i;
        }
        return null;
    }

    private void calculateHydrographs() throws UnsupportedOutputChannelException {
        double dRunoff2Volume = this.m_TimeOut.getWindowCellSize() * this.m_TimeOut.getWindowCellSize() / 1000.0;
        this.m_Hydrographs = new ArrayList();
        GridExtent extent = this.m_TimeOut.getWindowGridExtent();
        IRasterLayer accRainGrid = this.getTempRasterLayer(4, extent);
        IRasterLayer accRunoffGrid = this.getTempRasterLayer(4, extent);
        IRasterLayer runoffGrid = this.getTempRasterLayer(4, extent);
        int iLength = this.m_Hyetogram[0][0].getDuration();
        int iIntervalsHyeto = this.m_Hyetogram[0][0].getIntervals();
        int iRatio = this.m_iIntervalHyeto / this.m_iIntervalHydro;
        int iIntervalsHydro = (int)(((double)iLength + this.m_TimeOut.getMaxValue() * 3600.0) / (double)this.m_iIntervalHydro) + 1;
        int i = 0;
        while (i < this.m_Hyetogram[0].length) {
            accRainGrid.assign(0.0);
            accRunoffGrid.assign(0.0);
            runoffGrid.assign(0.0);
            double[] hydData = new double[iIntervalsHydro];
            int j = 0;
            while (j < iIntervalsHydro) {
                hydData[j] = 0.0;
                ++j;
            }
            this.setProgressText(String.valueOf(Sextante.getText((String)"Calculando_hidrograma")) + "(" + this.m_sHyetoNames[i] + ")");
            j = 0;
            while (j < iIntervalsHyeto) {
                double dTimeOut;
                int x;
                int y = 0;
                while (y < this.m_iNY) {
                    x = 0;
                    while (x < this.m_iNX) {
                        double dRain;
                        dTimeOut = this.m_TimeOut.getCellValueAsDouble(x, y);
                        if (!this.m_TimeOut.isNoDataValue(dTimeOut) && dTimeOut > 0.0 && (dRain = this.getRainfall(i, extent.getWorldCoordsFromGridCoords(x, y), j * this.m_iIntervalHyeto, this.m_iIntervalHyeto)) > 0.0) {
                            accRainGrid.addToCellValue(x, y, dRain);
                        }
                        ++x;
                    }
                    ++y;
                }
                this.calculateRunoffGrid(runoffGrid, accRainGrid);
                y = 1;
                while (y < this.m_iNY) {
                    x = 0;
                    while (x < this.m_iNX) {
                        dTimeOut = this.m_TimeOut.getCellValueAsDouble(x, y);
                        if (!this.m_TimeOut.isNoDataValue(dTimeOut) && dTimeOut > 0.0) {
                            int iIndex = (int)((dTimeOut * 3600.0 + (double)(j * this.m_iIntervalHyeto)) / (double)this.m_iIntervalHydro);
                            double dRunoff = runoffGrid.getCellValueAsDouble(x, y);
                            double dAccRunoff = accRunoffGrid.getCellValueAsDouble(x, y);
                            if ((dRunoff -= dAccRunoff) > 0.0) {
                                int k = 0;
                                while (k < iRatio) {
                                    int n = iIndex;
                                    hydData[n] = hydData[n] + dRunoff;
                                    ++k;
                                }
                            }
                        }
                        ++x;
                    }
                    ++y;
                }
                IRasterLayer swap = runoffGrid;
                runoffGrid = accRunoffGrid;
                accRunoffGrid = swap;
                this.setProgress(j, iIntervalsHyeto);
                ++j;
            }
            j = 0;
            while (j < iIntervalsHydro) {
                hydData[j] = hydData[j] * dRunoff2Volume / (double)iRatio / (double)this.m_iIntervalHydro;
                ++j;
            }
            Hydrograph hyd = new Hydrograph(hydData, this.m_iIntervalHydro);
            hyd.setName(this.m_Hyetogram[0][i].getName());
            this.m_Hydrographs.add(hyd);
            ++i;
        }
    }

    private double getRainfall(int iSerie, Point2D pt, int iInitTime, int iInterval) {
        double dTotalRainfall = 0.0;
        double dTotalWeight = 0.0;
        int i = 0;
        while (i < this.m_Hyetogram.length) {
            Point2D coords = this.m_Hyetogram[i][iSerie].getCoords();
            double dWeight = 1.0 / Math.pow(coords.distance(pt), 2.0);
            double dRainfall = this.m_Hyetogram[i][iSerie].getRainfall(iInitTime, iInterval) * dWeight;
            dTotalRainfall += dRainfall;
            dTotalWeight += dWeight;
            ++i;
        }
        return dTotalRainfall / dTotalWeight;
    }

    private void documentHydrographs() throws UnsupportedOutputChannelException {
        String[] sFields = new String[]{"T", "Q"};
        Object[] values = new Object[2];
        Class[] types = new Class[]{Integer.class, Double.class};
        int i = 0;
        while (i < this.m_Hydrographs.size()) {
            Hydrograph hydro = (Hydrograph)this.m_Hydrographs.get(i);
            String sTableName = "HYDROGRAPH" + Integer.toString(i);
            String sTableDescription = "Hidrograma (" + this.m_sHyetoNames[i] + ")";
            ITable driver = this.getNewTable(sTableName, sTableDescription, types, sFields);
            double[] flow = hydro.getFlowArray();
            int j = 0;
            while (j < hydro.getLengthInIntervals()) {
                values[0] = new Integer(j * hydro.getTimeInterval());
                values[1] = new Double(flow[j]);
                driver.addRecord(values);
                ++j;
            }
            this.setProgress(i, this.m_Hydrographs.size());
            ++i;
        }
    }

    private double getRunoff(double dRainfall, double dCN) {
        double dS = 25400.0 / dCN - 254.0;
        if (dRainfall < 0.2 * dS) {
            return 0.0;
        }
        double dRunoff = Math.pow(dRainfall - 0.2 * dS, 2.0) / (dRainfall + 0.8 * dS);
        return dRunoff;
    }

    private void calculateRunoffGrid(IRasterLayer runoff, IRasterLayer rainfall) {
        double dMean = 0.0;
        int i = 0;
        int y = 0;
        while (y < this.m_iNY) {
            int x = 0;
            while (x < this.m_iNX) {
                double dCN = this.m_CN.getCellValueAsDouble(x, y);
                double dRainfall = rainfall.getCellValueAsDouble(x, y);
                if (!this.m_CN.isNoDataValue(dCN) && dRainfall != 0.0) {
                    ++i;
                    double dRunoff = this.getRunoff(dRainfall, dCN);
                    runoff.setCellValue(x, y, dRunoff);
                    dMean += dRunoff;
                }
                ++x;
            }
            ++y;
        }
        dMean /= (double)i;
        dMean += 1.0;
    }

    public boolean isSuitableForModelling() {
        return false;
    }
}

