/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.maxValueUphill;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridExtent;

public class MaxValueUphillAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX;
    private static final int[] m_iOffsetY;
    private static final double NOT_VISITED = -1.0;
    public static final String DEM = "DEM";
    public static final String PARAM = "PARAM";
    public static final String RESULT = "RESULT";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Param = null;
    private IRasterLayer m_MaxValue;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        m_iOffsetX = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        m_iOffsetY = nArray2;
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Param = this.m_Parameters.getParameterValueAsRasterLayer(PARAM);
        this.m_MaxValue = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Valor_maximo_aguas_arriba"), 4, this.m_DEM);
        this.m_MaxValue.assign(-1.0);
        GridExtent extent = this.m_MaxValue.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        this.m_Param.setWindowExtent(extent);
        this.m_MaxValue.setNoDataValue(this.m_Param.getNoDataValue());
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.calculateMaxValues();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Valor_maximo_aguas_arriba"));
        this.setGroup(Sextante.getText((String)"Indices_y_otros_parametros_hidrologicos"));
        this.setGeneratesUserDefinedRasterOutput(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.m_Parameters.addInputRasterLayer(PARAM, Sextante.getText((String)"Parametro"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Valor_maximo_aguas_arriba"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateMaxValues() {
        int y = 0;
        while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
            int x = 0;
            while (x < this.m_iNX) {
                this.getMaxValue(x, y);
                ++x;
            }
            ++y;
        }
    }

    private void getMaxValue(int x, int y) {
        if (this.m_Task.isCanceled()) {
            return;
        }
        if (this.m_MaxValue.getCellValueAsDouble(x, y) != -1.0) {
            return;
        }
        double dValue = this.m_DEM.getCellValueAsDouble(x, y);
        if (!this.m_DEM.isNoDataValue(dValue)) {
            double dParamValue = this.m_Param.getCellValueAsDouble(x, y);
            if (!this.m_Param.isNoDataValue(dParamValue)) {
                this.m_MaxValue.setCellValue(x, y, dParamValue);
            }
            int i = 0;
            while (i < 8) {
                int iDirection;
                int ix = x + m_iOffsetX[i];
                int iy = y + m_iOffsetY[i];
                dValue = this.m_DEM.getCellValueAsDouble(ix, iy);
                if (!this.m_DEM.isNoDataValue(dValue) && (iDirection = this.m_DEM.getDirToNextDownslopeCell(ix, iy)) >= 0 && (i + 4) % 8 == iDirection) {
                    this.getMaxValue(ix, iy);
                    double dMaxValue = this.m_MaxValue.getCellValueAsDouble(x, y);
                    if (this.m_MaxValue.isNoDataValue(dMaxValue)) {
                        this.m_MaxValue.setCellValue(x, y, this.m_MaxValue.getCellValueAsDouble(ix, iy));
                    } else {
                        this.m_MaxValue.setCellValue(x, y, Math.max(this.m_MaxValue.getCellValueAsDouble(x, y), this.m_MaxValue.getCellValueAsDouble(ix, iy)));
                    }
                }
                ++i;
            }
        } else {
            this.m_MaxValue.setNoData(x, y);
        }
    }
}

