/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.modelling;

public class Hydrograph {
    protected double[] m_dFlow;
    protected int m_iTimeInterval;
    private String m_sName;

    public Hydrograph(int iInterval) {
        this.m_dFlow = new double[1];
        this.m_iTimeInterval = iInterval;
    }

    public Hydrograph(double[] H, int iInterval) {
        this.m_dFlow = H;
        this.m_iTimeInterval = iInterval;
    }

    public void delay(int iTime) {
        int iDelayIntervals = (int)((double)iTime / (double)this.m_iTimeInterval);
        double[] dFlow = new double[this.m_dFlow.length + iDelayIntervals];
        int i = 0;
        while (i < iDelayIntervals + 1) {
            dFlow[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.m_dFlow.length) {
            dFlow[i + iDelayIntervals] = this.m_dFlow[i];
            ++i;
        }
        this.m_dFlow = dFlow;
    }

    public void add(Hydrograph Hyd) {
        double dFlow1 = 0.0;
        double dFlow2 = 0.0;
        if (Hyd.getTimeInterval() == this.m_iTimeInterval) {
            int iLength = Math.max(Hyd.getLengthInIntervals(), this.m_dFlow.length);
            double[] dFlow = new double[iLength];
            int i = 0;
            while (i < iLength) {
                dFlow1 = i >= Hyd.getLengthInIntervals() ? 0.0 : Hyd.getFlow(this.m_iTimeInterval * i);
                dFlow2 = i >= this.m_dFlow.length ? 0.0 : this.m_dFlow[i];
                dFlow[i] = dFlow1 + dFlow2;
                ++i;
            }
            this.m_dFlow = dFlow;
        }
    }

    public void add(float fFlow) {
        int i = 0;
        while (i < this.m_dFlow.length) {
            int n = i++;
            this.m_dFlow[n] = this.m_dFlow[n] + (double)fFlow;
        }
    }

    public double getFlow(int iTime) {
        int iIndex = (int)((double)iTime / (double)this.m_iTimeInterval);
        return this.m_dFlow[iIndex];
    }

    public int getTimeInterval() {
        return this.m_iTimeInterval;
    }

    public int getLengthInIntervals() {
        return this.m_dFlow.length;
    }

    public double getTotalRunoff() {
        double dRunoff = 0.0;
        int i = 0;
        while (i < this.m_dFlow.length - 1) {
            dRunoff += (this.m_dFlow[i] + this.m_dFlow[i + 1]) / 2.0 * (double)this.m_iTimeInterval;
            ++i;
        }
        return dRunoff;
    }

    public double getPeak() {
        double dMax = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.m_dFlow.length) {
            if (this.m_dFlow[i] > dMax) {
                dMax = this.m_dFlow[i];
            }
            ++i;
        }
        return dMax;
    }

    public int getPeakTime() {
        double dMax = Double.NEGATIVE_INFINITY;
        int iMaxTime = 0;
        int i = 0;
        while (i < this.m_dFlow.length) {
            if (this.m_dFlow[i] > dMax) {
                dMax = this.m_dFlow[i];
                iMaxTime = i * this.m_iTimeInterval;
            }
            ++i;
        }
        return iMaxTime;
    }

    public double[] getFlowArray() {
        return this.m_dFlow;
    }

    public void multiply(double fFactor) {
        int i = 0;
        while (i < this.m_dFlow.length) {
            int n = i++;
            this.m_dFlow[n] = this.m_dFlow[n] * fFactor;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Caudal Punta : " + this.getPeak() + " m3/s\n");
        sb.append("Tiempo al Pico : " + Hydrograph.transformSecToHourMin(this.getPeakTime()) + " \n");
        sb.append("Volumen total de escorrent\u00eda : " + this.getTotalRunoff() + " m3\n");
        sb.append("Duraci\u00f3n total del hidrograma : " + Hydrograph.transformSecToHourMin(this.getLengthInIntervals() * this.m_iTimeInterval) + "\n");
        return sb.toString();
    }

    public static String transformSecToHourMin(int iSec) {
        int iHours = (int)((double)iSec / 3600.0);
        int iMin = (int)((double)(iSec - iHours * 3600) / 60.0);
        return new String(String.valueOf(Integer.toString(iHours)) + "h" + Integer.toString(iMin) + "min");
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public String getName() {
        return this.m_sName;
    }
}

