/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.modelling;

import java.awt.geom.Point2D;

public class Hyetograph {
    private double[] m_dRainfall;
    private int m_iTimeInterval;
    private Point2D m_Coords;
    private String m_sName;

    public Hyetograph(double dP24, int iTime, int iTimeInterval, int iPeakTime, int iReturn, int iRatioI1) {
        int iLength = (int)((double)iTime / (double)iTimeInterval);
        double[] dRain = new double[iLength];
        double dAccRain = 0.0;
        double dTotalRain = 0.0;
        int i = 0;
        while (i < iLength) {
            dTotalRain = this.getIntensity((double)(iTimeInterval * (i + 1)) / 3600.0, dP24, iRatioI1) * (double)(iTimeInterval * (i + 1)) / 3600.0;
            dRain[i] = dTotalRain - dAccRain;
            dAccRain = dTotalRain;
            ++i;
        }
        this.m_iTimeInterval = iTimeInterval;
        int iPeakInterval = (int)((float)iPeakTime / (float)iTimeInterval) - 1;
        int iMaxIntervals = Math.max(iPeakInterval, iLength - 1 - iPeakInterval);
        this.m_dRainfall = new double[iLength];
        int iInterval = 0;
        int iRainInterval = 0;
        this.m_dRainfall[iPeakInterval] = dRain[0];
        i = 1;
        while (i < iMaxIntervals + 1) {
            iInterval = iPeakInterval + i;
            if (iInterval < iLength) {
                this.m_dRainfall[iInterval] = dRain[++iRainInterval];
            }
            if ((iInterval = iPeakInterval - i) >= 0) {
                this.m_dRainfall[iInterval] = dRain[++iRainInterval];
            }
            ++i;
        }
    }

    public Hyetograph(double[] dRainfall, int iTimeInterval) {
        this.m_dRainfall = new double[dRainfall.length];
        int i = 0;
        while (i < dRainfall.length) {
            this.m_dRainfall[i] = dRainfall[i];
            ++i;
        }
        this.m_iTimeInterval = iTimeInterval;
    }

    public Hyetograph(double dP05, double dP1, double dP6) {
        double dDelta = dP6 - dP1;
        this.m_dRainfall = new double[12];
        this.m_dRainfall[0] = dDelta * (double)0.15f / 2.0;
        this.m_dRainfall[1] = dDelta * (double)0.15f / 2.0;
        this.m_dRainfall[2] = dDelta * (double)0.17f / 2.0;
        this.m_dRainfall[3] = dDelta * (double)0.17f / 2.0;
        this.m_dRainfall[4] = dDelta * (double)0.19f / 2.0;
        this.m_dRainfall[5] = dDelta * (double)0.19f / 2.0;
        this.m_dRainfall[6] = dP05;
        this.m_dRainfall[7] = dP1 - dP05;
        this.m_dRainfall[8] = dDelta * (double)0.32f / 2.0;
        this.m_dRainfall[9] = dDelta * (double)0.32f / 2.0;
        this.m_dRainfall[10] = dDelta * (double)0.17f / 2.0;
        this.m_dRainfall[11] = dDelta * (double)0.17f / 2.0;
        this.m_iTimeInterval = 1800;
    }

    public int getDuration() {
        return this.m_dRainfall.length * this.m_iTimeInterval;
    }

    public int getIntervals() {
        return this.m_dRainfall.length;
    }

    public void delay(int iTime) {
        int iDelayIntervals = (int)((double)iTime / (double)this.m_iTimeInterval);
        double[] dRainfall = new double[this.m_dRainfall.length + iDelayIntervals];
        int i = 0;
        while (i < this.m_dRainfall.length) {
            dRainfall[i + iDelayIntervals] = this.m_dRainfall[i];
            ++i;
        }
        this.m_dRainfall = dRainfall;
    }

    public int getTimeInterval() {
        return this.m_iTimeInterval;
    }

    public double[] getRainfallArray() {
        return this.m_dRainfall;
    }

    public double getAverageRainfallIntensity() {
        double dAverage = 0.0;
        int i = 0;
        while (i < this.m_dRainfall.length) {
            dAverage += this.m_dRainfall[i];
            ++i;
        }
        return dAverage /= (double)((float)this.m_dRainfall.length * (float)this.m_iTimeInterval);
    }

    public double getIntensity(double dInitTime, double dDuration) {
        return this.getRainfall(dInitTime, dDuration) / dDuration;
    }

    public double getRainfall(double dInitTime, double dDuration) {
        double dTotal = 0.0;
        int iInitInterval = (int)Math.floor(dInitTime / (double)this.m_iTimeInterval);
        int iEndInterval = (int)Math.floor((dInitTime + dDuration) / (double)this.m_iTimeInterval);
        iInitInterval = Math.max(iInitInterval, 0);
        iEndInterval = Math.min(iEndInterval, this.m_dRainfall.length - 1);
        int i = iInitInterval;
        while (i < iEndInterval + 1) {
            dTotal += this.m_dRainfall[i];
            ++i;
        }
        dTotal -= this.m_dRainfall[iInitInterval] * (dInitTime / (double)this.m_iTimeInterval - (double)iInitInterval);
        return dTotal -= this.m_dRainfall[iEndInterval] * (1.0 - ((dInitTime + dDuration) / (double)this.m_iTimeInterval - (double)iEndInterval));
    }

    public double getTotalRainfall() {
        double dTotal = 0.0;
        int i = 0;
        while (i < this.m_dRainfall.length) {
            dTotal += this.m_dRainfall[i];
            ++i;
        }
        return dTotal;
    }

    public void normalize() {
        double dTotal = this.getTotalRainfall();
        int i = 0;
        while (i < this.m_dRainfall.length) {
            int n = i++;
            this.m_dRainfall[n] = this.m_dRainfall[n] / dTotal;
        }
    }

    public Hyetograph getNormalized() {
        Hyetograph hyet = new Hyetograph(this.m_dRainfall, this.m_iTimeInterval);
        hyet.normalize();
        return hyet;
    }

    private double getIntensity(double dTime, double dP24, int iRatioI1) {
        double dI = dP24 / 24.0 * Math.pow(iRatioI1, (Math.pow(28.0, 0.1) - Math.pow(dTime, 0.1)) / (Math.pow(28.0, 0.1) - 1.0));
        return dI;
    }

    public void setCoords(Point2D coords) {
        this.m_Coords = coords;
    }

    public Point2D getCoords() {
        return this.m_Coords;
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public String getName() {
        return this.m_sName;
    }

    public double getRainfallAtInterval(int iInterval) {
        if (iInterval < this.m_dRainfall.length && iInterval > 0) {
            return this.m_dRainfall[iInterval];
        }
        return 0.0;
    }
}

