/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.slopeLength;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import es.unex.sextante.rasterWrappers.GridExtent;
import java.util.Arrays;

public class SlopeLengthAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX;
    private static final int[] m_iOffsetY;
    public static final String DEM = "DEM";
    public static final String USETHRESHOLD = "USETHRESHOLD";
    public static final String THRESHOLD = "THRESHOLD";
    public static final String SLOPELENGTH = "SLOPELENGTH";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_SlopeLength;
    private IRasterLayer m_Slope;
    private double m_dThreshold;
    private boolean m_bUseThreshold;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        m_iOffsetX = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        m_iOffsetY = nArray2;
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_bUseThreshold = this.m_Parameters.getParameterValueAsBoolean(USETHRESHOLD);
        this.m_dThreshold = Math.abs(this.m_Parameters.getParameterValueAsDouble(THRESHOLD));
        this.m_SlopeLength = this.getNewRasterLayer(SLOPELENGTH, Sextante.getText((String)"Longitud_de_pendiente"), 4, this.m_DEM);
        this.m_SlopeLength.assign(0.0);
        GridExtent extent = this.m_SlopeLength.getWindowGridExtent();
        this.m_Slope = this.getTempRasterLayer(4, extent);
        this.m_DEM.setWindowExtent(extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        if (this.m_bUseThreshold) {
            this.createSlopeLayer();
        }
        GridCell[] cells = this.getSortedArrayOfCells(this.m_DEM);
        int iCells = cells.length;
        int i = iCells - 1;
        while (i > -1 && this.setProgress(iCells - i, iCells)) {
            this.setLength(cells[i].getX(), cells[i].getY());
            --i;
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Longitud_de_pendiente"));
        this.setGroup(Sextante.getText((String)"Indices_y_otros_parametros_hidrologicos"));
        this.setGeneratesUserDefinedRasterOutput(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.m_Parameters.addNumericalValue(THRESHOLD, Sextante.getText((String)"Relacion_umbral_de_variacion_de_pendiente"), 0.5, 2);
            this.m_Parameters.addBoolean(USETHRESHOLD, Sextante.getText((String)"Utilizar_umbral"), true);
            this.addOutputRasterLayer(SLOPELENGTH, Sextante.getText((String)"Longitud_de_pendiente"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void createSlopeLayer() {
        int y = 0;
        while (y < this.m_iNY) {
            int x = 0;
            while (x < this.m_iNX) {
                this.m_Slope.setCellValue(x, y, this.m_DEM.getSlope(x, y));
                ++x;
            }
            ++y;
        }
    }

    private void setLength(int x, int y) {
        int i;
        double dValue = this.m_DEM.getCellValueAsDouble(x, y);
        if (!this.m_DEM.isNoDataValue(dValue) && (i = this.m_DEM.getDirToNextDownslopeCell(x, y)) >= 0) {
            int ix = x + m_iOffsetX[i];
            int iy = y + m_iOffsetY[i];
            dValue = this.m_DEM.getCellValueAsDouble(ix, iy);
            if (!this.m_DEM.isNoDataValue(dValue)) {
                if (this.m_bUseThreshold) {
                    double dSlope = this.m_Slope.getCellValueAsDouble(x, y);
                    double dSlope2 = this.m_Slope.getCellValueAsDouble(ix, iy);
                    double dLength = Math.abs(dSlope2) > this.m_dThreshold * Math.abs(dSlope) ? this.m_SlopeLength.getCellValueAsDouble(x, y) + this.m_DEM.getDistToNeighborInDir(i) : this.m_DEM.getDistToNeighborInDir(i);
                    if (dLength > this.m_SlopeLength.getCellValueAsDouble(ix, iy)) {
                        this.m_SlopeLength.setCellValue(ix, iy, dLength);
                    }
                } else {
                    double dLength = this.m_SlopeLength.getCellValueAsDouble(x, y) + this.m_DEM.getDistToNeighborInDir(i);
                    if (dLength > this.m_SlopeLength.getCellValueAsDouble(ix, iy)) {
                        this.m_SlopeLength.setCellValue(ix, iy, dLength);
                    }
                }
            }
        } else {
            this.m_SlopeLength.setNoData(x, y);
        }
    }

    public GridCell[] getSortedArrayOfCells(IRasterLayer layer) {
        int iNX = layer.getNX();
        int iCells = layer.getNX() * layer.getNY();
        Object[] cells = new GridCell[iCells];
        int i = 0;
        while (i < iCells) {
            int iX = i % iNX;
            int iY = i / iNX;
            GridCell cell = new GridCell(iX, iY, layer.getCellValueAsDouble(iX, iY));
            cells[i] = cell;
            ++i;
        }
        Arrays.sort(cells);
        return cells;
    }
}

