/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.strahlerOrder;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridExtent;

public class StrahlerOrderAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX;
    private static final int[] m_iOffsetY;
    public static final String DEM = "DEM";
    public static final String RESULT = "RESULT";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Strahler;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        m_iOffsetX = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        m_iOffsetY = nArray2;
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Strahler = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Orden_de_strahler"), 3, this.m_DEM);
        this.m_Strahler.assign(0.0);
        GridExtent extent = this.m_Strahler.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        int y = 0;
        while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
            int x = 0;
            while (x < this.m_iNX) {
                this.getStrahlerOrder(x, y);
                ++x;
            }
            ++y;
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Orden_de_strahler"));
        this.setGroup(Sextante.getText((String)"Indices_y_otros_parametros_hidrologicos"));
        this.setGeneratesUserDefinedRasterOutput(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Orden_de_strahler"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void getStrahlerOrder(int x, int y) {
        int iMaxOrder = 1;
        int iOrder = 1;
        int iMaxOrderCells = 0;
        if (this.m_DEM.isNoDataValue(this.m_DEM.getCellValueAsDouble(x, y))) {
            return;
        }
        if (this.m_Strahler.getCellValueAsInt(x, y) == 0) {
            this.m_Strahler.setCellValue(x, y, (double)iMaxOrder);
            int i = 0;
            while (i < 8) {
                int ix = x + m_iOffsetX[i];
                int iy = y + m_iOffsetY[i];
                int iDirection = this.m_DEM.getDirToNextDownslopeCell(ix, iy);
                if (iDirection == (i + 4) % 8) {
                    this.getStrahlerOrder(ix, iy);
                    iOrder = this.m_Strahler.getCellValueAsInt(ix, iy);
                    if (iOrder > iMaxOrder) {
                        iMaxOrder = iOrder;
                        iMaxOrderCells = 1;
                    } else if (iOrder == iMaxOrder) {
                        ++iMaxOrderCells;
                    }
                }
                ++i;
            }
            if (iMaxOrderCells > 1) {
                ++iMaxOrder;
            }
            this.m_Strahler.setCellValue(x, y, (double)iMaxOrder);
        }
    }
}

