/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.topographicIndices;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridExtent;

public class TopographicIndicesAlgorithm
extends GeoAlgorithm {
    private static final double ALMOST_ZERO = 0.0011;
    public static final String SLOPE = "SLOPE";
    public static final String ACCFLOW = "ACCFLOW";
    public static final String TWI = "TWI";
    public static final String SPI = "SPI";
    public static final String LS = "LS";
    private IRasterLayer m_Slope = null;
    private IRasterLayer m_AccFlow = null;
    private IRasterLayer m_WetnessIndex;
    private IRasterLayer m_StreamPowerIndex;
    private IRasterLayer m_LSFactor;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_AccFlow = this.m_Parameters.getParameterValueAsRasterLayer(ACCFLOW);
        this.m_Slope = this.m_Parameters.getParameterValueAsRasterLayer(SLOPE);
        this.m_WetnessIndex = this.getNewRasterLayer(TWI, Sextante.getText((String)"Indice_de_humedad_topografica"), 4);
        this.m_StreamPowerIndex = this.getNewRasterLayer(SPI, Sextante.getText((String)"Indice_de_potencia_de_cauce"), 4);
        this.m_LSFactor = this.getNewRasterLayer(LS, Sextante.getText((String)"Factor_ls"), 4);
        GridExtent extent = this.m_WetnessIndex.getWindowGridExtent();
        this.m_Slope.setWindowExtent(extent);
        this.m_AccFlow.setWindowExtent(extent);
        int iNX = this.m_Slope.getNX();
        int iNY = this.m_Slope.getNY();
        int y = 0;
        while (y < iNY && this.setProgress(y, iNY)) {
            int x = 0;
            while (x < iNX) {
                this.calculateIndices(x, y);
                ++x;
            }
            ++y;
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Indices_topograficos"));
        this.setGroup(Sextante.getText((String)"Indices_y_otros_parametros_hidrologicos"));
        this.setGeneratesUserDefinedRasterOutput(true);
        try {
            this.m_Parameters.addInputRasterLayer(SLOPE, Sextante.getText((String)"Pendiente"), true);
            this.m_Parameters.addInputRasterLayer(ACCFLOW, Sextante.getText((String)"Acumulacion_de_flujo"), true);
            this.addOutputRasterLayer(TWI, Sextante.getText((String)"Indice_de_humedad_topografica"));
            this.addOutputRasterLayer(SPI, Sextante.getText((String)"Indice_de_potencia_de_cauce"));
            this.addOutputRasterLayer(LS, Sextante.getText((String)"Factor_ls"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateIndices(int x, int y) {
        double dSlope = this.m_Slope.getCellValueAsDouble(x, y);
        double dAccFlow = this.m_AccFlow.getCellValueAsDouble(x, y);
        if (this.m_Slope.isNoDataValue(dSlope) || this.m_AccFlow.isNoDataValue(dAccFlow)) {
            this.m_WetnessIndex.setNoData(x, y);
            this.m_StreamPowerIndex.setNoData(x, y);
            this.m_LSFactor.setNoData(x, y);
        } else {
            dSlope = Math.max(Math.tan(dSlope), 0.0011);
            this.m_WetnessIndex.setCellValue(x, y, Math.log((dAccFlow /= this.m_AccFlow.getWindowCellSize()) / dSlope));
            this.m_StreamPowerIndex.setCellValue(x, y, dAccFlow * dSlope);
            this.m_LSFactor.setCellValue(x, y, 1.4 * Math.pow(dAccFlow / 22.13, 0.4) * Math.pow(Math.sin(dSlope) / 0.0896, 1.3));
        }
    }
}

