/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.upslopeAreaFromArea;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridExtent;

public class UpslopeAreaFromAreaAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX;
    private static final int[] m_iOffsetY;
    private static final double NOT_VISITED = 0.0;
    private static final double VISITED = 1.0;
    public static final String DEM = "DEM";
    public static final String INITZONES = "INITZONES";
    public static final String RESULT = "RESULT";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_InitZone = null;
    private IRasterLayer m_Result;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        m_iOffsetX = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        m_iOffsetY = nArray2;
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_InitZone = this.m_Parameters.getParameterValueAsRasterLayer(INITZONES);
        this.m_DEM.setFullExtent();
        GridExtent extent = this.m_DEM.getWindowGridExtent();
        this.m_InitZone.setWindowExtent(extent);
        this.m_InitZone.setInterpolationMethod(0);
        this.m_Result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Area_aguas_arriba"), 0, extent);
        this.m_Result.assign(0.0);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.calculateUpslopeArea();
        this.m_Result.setNoDataValue(0.0);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Area_aguas_arriba_de_area"));
        this.setGroup(Sextante.getText((String)"Analisis_hidrologico_basico"));
        this.setGeneratesUserDefinedRasterOutput(false);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.m_Parameters.addInputRasterLayer(INITZONES, Sextante.getText((String)"Zona_de_salida"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Area_aguas_arriba"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateUpslopeArea() {
        int y = 0;
        while (y < this.m_iNY) {
            int x = 0;
            while (x < this.m_iNX) {
                double dValue = this.m_InitZone.getCellValueAsDouble(x, y);
                if (!this.m_InitZone.isNoDataValue(dValue)) {
                    this.calculateUpslopeAreaFromPoint(x, y);
                }
                ++x;
            }
            ++y;
        }
    }

    private void calculateUpslopeAreaFromPoint(int x, int y) {
        if (this.m_Result.getCellValueAsDouble(x, y) != 0.0 || this.m_Task.isCanceled()) {
            return;
        }
        double dValue = this.m_DEM.getCellValueAsDouble(x, y);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return;
        }
        this.m_Result.setCellValue(x, y, 1.0);
        int i = 0;
        while (i < 8) {
            int iDirection;
            int ix = x + m_iOffsetX[i];
            int iy = y + m_iOffsetY[i];
            dValue = this.m_DEM.getCellValueAsDouble(ix, iy);
            if (!this.m_DEM.isNoDataValue(dValue) && (iDirection = this.m_DEM.getDirToNextDownslopeCell(ix, iy)) >= 0 && (i + 4) % 8 == iDirection) {
                this.calculateUpslopeAreaFromPoint(ix, iy);
            }
            ++i;
        }
    }
}

