/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.upslopeAreaFromPoint;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import es.unex.sextante.rasterWrappers.GridExtent;
import java.awt.geom.Point2D;

public class UpslopeAreaFromPointAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX;
    private static final int[] m_iOffsetY;
    public static final String DEM = "DEM";
    public static final String OUTLET = "OUTLET";
    public static final String RESULT = "RESULT";
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Watershed;
    private GridCell m_Outlet;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        m_iOffsetX = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        m_iOffsetY = nArray2;
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        Point2D pt = this.m_Parameters.getParameterValueAsPoint(OUTLET);
        GridExtent gridExtent = new GridExtent((ILayer)this.m_DEM);
        this.m_DEM.setFullExtent();
        this.m_Watershed = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Area_aguas_arriba"), 0, gridExtent);
        this.m_Watershed.assign(0.0);
        this.m_Outlet = gridExtent.getGridCoordsFromWorldCoords(pt);
        this.calculateWatershed();
        this.m_Watershed.setNoDataValue(0.0);
        return true;
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Cuenca_vertiente_a_un_punto_dado"));
        this.setGroup(Sextante.getText((String)"Analisis_hidrologico_basico"));
        this.setGeneratesUserDefinedRasterOutput(false);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.m_Parameters.addPoint(OUTLET, Sextante.getText((String)"Punto_de_salida"));
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Area_aguas_arriba"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateWatershed() {
        this.writeCell(this.m_Outlet.getX(), this.m_Outlet.getY());
    }

    private void writeCell(int iX, int iY) {
        double dValue = this.m_DEM.getCellValueAsDouble(iX, iY);
        if (!this.m_DEM.isNoDataValue(dValue)) {
            this.m_Watershed.setCellValue(iX, iY, 1.0);
            int i = 0;
            while (i < 8) {
                int iDirection;
                int ix = iX + m_iOffsetX[i];
                int iy = iY + m_iOffsetY[i];
                dValue = this.m_DEM.getCellValueAsDouble(ix, iy);
                if (!this.m_DEM.isNoDataValue(dValue) && (iDirection = this.m_DEM.getDirToNextDownslopeCell(ix, iy)) >= 0 && (i + 4) % 8 == iDirection) {
                    this.writeCell(ix, iy);
                }
                ++i;
            }
        }
    }
}

