/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.usped;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.hydrology.accFlow.AccFlowAlgorithm;
import es.unex.sextante.morphometry.aspect.AspectAlgorithm;
import es.unex.sextante.morphometry.slope.SlopeAlgorithm;

public class USPEDAlgorithm
extends GeoAlgorithm {
    public static final String DEM = "DEM";
    public static final String USPED = "USPED";
    public static final String K = "K";
    public static final String C = "C";
    public static final String R = "R";
    public static final String EROSIONTYPE = "EROSIONTYPE";
    public static int EROSIONTYPE_RILL = 0;
    public static int EROSIONTYPE_SHEET = 1;
    private IRasterLayer m_USPED;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_K;
    private IRasterLayer m_C;
    private double m_R;
    private int m_iNY;
    private int m_iNX;
    private int m_iErosionType;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double dSlope;
        double dAccFlow;
        int x;
        int y;
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_K = this.m_Parameters.getParameterValueAsRasterLayer(K);
        this.m_C = this.m_Parameters.getParameterValueAsRasterLayer(C);
        this.m_R = this.m_Parameters.getParameterValueAsDouble(R);
        this.m_iErosionType = this.m_Parameters.getParameterValueAsInt(EROSIONTYPE);
        this.m_DEM.setWindowExtent(this.m_GridExtent);
        this.m_K.setWindowExtent(this.m_GridExtent);
        this.m_C.setWindowExtent(this.m_GridExtent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        SlopeAlgorithm slopeAlg = new SlopeAlgorithm();
        slopeAlg.setGridExtent(this.m_GridExtent);
        ParametersSet params = slopeAlg.getParameters();
        params.getParameter(DEM).setParameterValue((Object)this.m_DEM);
        params.getParameter("METHOD").setParameterValue((Object)5);
        slopeAlg.execute(this.m_Task, this.m_OutputFactory);
        IRasterLayer slope = (IRasterLayer)slopeAlg.getOutputObjects().getOutput("SLOPE").getOutputObject();
        slope.open();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        this.m_DEM.open();
        AspectAlgorithm aspectAlg = new AspectAlgorithm();
        aspectAlg.setGridExtent(this.m_GridExtent);
        params = aspectAlg.getParameters();
        params.getParameter(DEM).setParameterValue((Object)this.m_DEM);
        params.getParameter("METHOD").setParameterValue((Object)5);
        aspectAlg.execute(this.m_Task, this.m_OutputFactory);
        IRasterLayer aspect = (IRasterLayer)slopeAlg.getOutputObjects().getOutput("SLOPE").getOutputObject();
        aspect.open();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        this.m_DEM.open();
        AccFlowAlgorithm accFlowAlg = new AccFlowAlgorithm();
        accFlowAlg.setGridExtent(this.m_GridExtent);
        params = accFlowAlg.getParameters();
        params.getParameter(DEM).setParameterValue((Object)this.m_DEM);
        accFlowAlg.execute(this.m_Task, this.m_OutputFactory);
        IRasterLayer accFlow = (IRasterLayer)accFlowAlg.getOutputObjects().getOutput("FLOWACC").getOutputObject();
        accFlow.open();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        this.m_Task.setProcessDescription("sflowtopo calculation");
        IRasterLayer sFlowTopo = this.getTempRasterLayer(4, this.m_GridExtent);
        double dCellSize = this.m_GridExtent.getCellSize();
        if (this.m_iErosionType == EROSIONTYPE_SHEET) {
            y = 0;
            while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
                x = 0;
                while (x < this.m_iNX) {
                    dAccFlow = accFlow.getCellValueAsDouble(x, y);
                    dSlope = slope.getCellValueAsDouble(x, y);
                    if (!accFlow.isNoDataValue(dAccFlow) && !slope.isNoDataValue(dSlope)) {
                        sFlowTopo.setCellValue(x, y, dAccFlow / dCellSize * Math.sin(dSlope));
                    } else {
                        sFlowTopo.setNoData(x, y);
                    }
                    ++x;
                }
                ++y;
            }
        } else {
            y = 0;
            while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
                x = 0;
                while (x < this.m_iNX) {
                    dAccFlow = accFlow.getCellValueAsDouble(x, y);
                    dSlope = slope.getCellValueAsDouble(x, y);
                    if (!accFlow.isNoDataValue(dAccFlow) && !slope.isNoDataValue(dSlope)) {
                        sFlowTopo.setCellValue(x, y, Math.pow(dAccFlow / dCellSize, 0.6) * Math.pow(Math.sin(dSlope), 1.3));
                    } else {
                        sFlowTopo.setNoData(x, y);
                    }
                    ++x;
                }
                ++y;
            }
        }
        IRasterLayer qsx = this.getTempRasterLayer(4, this.m_GridExtent);
        int y2 = 0;
        while (y2 < this.m_iNY && this.setProgress(y2, this.m_iNY)) {
            int x2 = 0;
            while (x2 < this.m_iNX) {
                double dK = this.m_K.getCellValueAsDouble(x2, y2);
                double dC = this.m_C.getCellValueAsDouble(x2, y2);
                double dSFlowTopo = sFlowTopo.getCellValueAsDouble(x2, y2);
                double dAspect = aspect.getCellValueAsDouble(x2, y2);
                if (!(this.m_K.isNoDataValue(dK) || this.m_C.isNoDataValue(dC) || aspect.isNoDataValue(dAspect) || sFlowTopo.isNoDataValue(dSFlowTopo))) {
                    qsx.setCellValue(x2, y2, dSFlowTopo * dK * dC * this.m_R * Math.cos(-dAspect + 7.853981633974483));
                } else {
                    qsx.setNoData(x2, y2);
                }
                ++x2;
            }
            ++y2;
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        IRasterLayer qsy = this.getTempRasterLayer(4, this.m_GridExtent);
        int y3 = 0;
        while (y3 < this.m_iNY && this.setProgress(y3, this.m_iNY)) {
            int x3 = 0;
            while (x3 < this.m_iNX) {
                double dK = this.m_K.getCellValueAsDouble(x3, y3);
                double dC = this.m_C.getCellValueAsDouble(x3, y3);
                double dSFlowTopo = sFlowTopo.getCellValueAsDouble(x3, y3);
                double dAspect = aspect.getCellValueAsDouble(x3, y3);
                if (!(this.m_K.isNoDataValue(dK) || this.m_C.isNoDataValue(dC) || aspect.isNoDataValue(dAspect) || sFlowTopo.isNoDataValue(dSFlowTopo))) {
                    qsy.setCellValue(x3, y3, dSFlowTopo * dK * dC * this.m_R * Math.sin(-dAspect + 7.853981633974483));
                } else {
                    qsy.setNoData(x3, y3);
                }
                ++x3;
            }
            ++y3;
        }
        slopeAlg = new SlopeAlgorithm();
        slopeAlg.setGridExtent(this.m_GridExtent);
        params = slopeAlg.getParameters();
        params.getParameter(DEM).setParameterValue((Object)qsx);
        params.getParameter("METHOD").setParameterValue((Object)5);
        slopeAlg.execute(this.m_Task, this.m_OutputFactory);
        IRasterLayer qsx_slope = (IRasterLayer)slopeAlg.getOutputObjects().getOutput("SLOPE").getOutputObject();
        qsx_slope.open();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        qsx.open();
        aspectAlg = new AspectAlgorithm();
        aspectAlg.setGridExtent(this.m_GridExtent);
        params = aspectAlg.getParameters();
        params.getParameter(DEM).setParameterValue((Object)qsx);
        params.getParameter("METHOD").setParameterValue((Object)5);
        aspectAlg.execute(this.m_Task, this.m_OutputFactory);
        IRasterLayer qsx_aspect = (IRasterLayer)slopeAlg.getOutputObjects().getOutput("SLOPE").getOutputObject();
        qsx_aspect.open();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        slopeAlg = new SlopeAlgorithm();
        slopeAlg.setGridExtent(this.m_GridExtent);
        params = slopeAlg.getParameters();
        params.getParameter(DEM).setParameterValue((Object)qsy);
        params.getParameter("METHOD").setParameterValue((Object)5);
        slopeAlg.execute(this.m_Task, this.m_OutputFactory);
        IRasterLayer qsy_slope = (IRasterLayer)slopeAlg.getOutputObjects().getOutput("SLOPE").getOutputObject();
        qsy_slope.open();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        qsy.open();
        aspectAlg = new AspectAlgorithm();
        aspectAlg.setGridExtent(this.m_GridExtent);
        params = aspectAlg.getParameters();
        params.getParameter(DEM).setParameterValue((Object)qsy);
        params.getParameter("METHOD").setParameterValue((Object)5);
        aspectAlg.execute(this.m_Task, this.m_OutputFactory);
        IRasterLayer qsy_aspect = (IRasterLayer)slopeAlg.getOutputObjects().getOutput("SLOPE").getOutputObject();
        qsy_aspect.open();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        IRasterLayer qsx_dx = this.getTempRasterLayer(4, this.m_GridExtent);
        int y4 = 0;
        while (y4 < this.m_iNY && this.setProgress(y4, this.m_iNY)) {
            int x4 = 0;
            while (x4 < this.m_iNX) {
                double qsxa = qsx_aspect.getCellValueAsDouble(x4, y4);
                double qsxs = qsx_slope.getCellValueAsDouble(x4, y4);
                if (!qsx_aspect.isNoDataValue(qsxa) && !qsx_slope.isNoDataValue(qsxs)) {
                    qsx_dx.setCellValue(x4, y4, Math.sin(-qsxa + 7.853981633974483) * Math.tan(qsxs));
                } else {
                    qsx_dx.setNoData(x4, y4);
                }
                ++x4;
            }
            ++y4;
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        this.m_USPED = this.getNewRasterLayer(USPED, USPED, 4);
        int iFactor = this.m_iErosionType == EROSIONTYPE_RILL ? 1 : 10;
        int y5 = 0;
        while (y5 < this.m_iNY && this.setProgress(y5, this.m_iNY)) {
            int x5 = 0;
            while (x5 < this.m_iNX) {
                double qsya = qsy_aspect.getCellValueAsDouble(x5, y5);
                double qsys = qsy_slope.getCellValueAsDouble(x5, y5);
                double qsxdx = qsx_dx.getCellValueAsDouble(x5, y5);
                if (!(qsy_aspect.isNoDataValue(qsya) || qsy_slope.isNoDataValue(qsys) || qsx_dx.isNoDataValue(qsxdx))) {
                    double qsxdy = Math.sin(-qsya + 7.853981633974483) * Math.tan(qsys);
                    this.m_USPED.setCellValue(x5, y5, (qsxdx + qsxdy) * (double)iFactor);
                } else {
                    this.m_USPED.setNoData(x5, y5);
                }
                ++x5;
            }
            ++y5;
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setGeneratesUserDefinedRasterOutput(true);
        this.setGroup(Sextante.getText((String)"Indices_y_otros_parametros_hidrologicos"));
        this.setName(USPED);
        String[] sErosionTypes = new String[]{Sextante.getText((String)"Erosion_carcavas"), Sextante.getText((String)"Erosion_ladera")};
        try {
            this.m_Parameters.addInputRasterLayer(DEM, "mde", true);
            this.m_Parameters.addInputRasterLayer(K, K, true);
            this.m_Parameters.addInputRasterLayer(C, C, true);
            this.m_Parameters.addNumericalValue(R, R, 2, 100.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addSelection(EROSIONTYPE, Sextante.getText((String)"Erosion_predominante"), sErosionTypes);
            this.addOutputRasterLayer(USPED, USPED);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

