/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.watersheds;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import es.unex.sextante.rasterWrappers.GridExtent;
import java.util.ArrayList;
import java.util.Arrays;

public class WatershedsAlgorithm
extends GeoAlgorithm {
    private static final int NO_BASIN = -1;
    private static final int[] m_iOffsetX;
    private static final int[] m_iOffsetY;
    public static final String DEM = "DEM";
    public static final String NETWORK = "NETWORK";
    public static final String MINSIZE = "MINSIZE";
    public static final String WATERSHEDS = "WATERSHEDS";
    private int m_iBasins;
    private int m_iNX;
    private int m_iNY;
    private int m_iMinSize;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Network = null;
    private IRasterLayer m_Basins;
    private IRasterLayer m_Directions;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        m_iOffsetX = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        m_iOffsetY = nArray2;
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Network = this.m_Parameters.getParameterValueAsRasterLayer(NETWORK);
        this.m_iMinSize = this.m_Parameters.getParameterValueAsInt(MINSIZE);
        this.m_Basins = this.getNewRasterLayer(WATERSHEDS, Sextante.getText((String)"Cuencas"), 3, this.m_DEM);
        this.m_Basins.setNoDataValue(-1.0);
        this.m_Basins.assignNoData();
        GridExtent extent = this.m_Basins.getWindowGridExtent();
        this.m_DEM.setFullExtent();
        this.m_Network.setWindowExtent(extent);
        this.m_Directions = this.getTempRasterLayer(3, extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.calculateBasins();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Cuencas"));
        this.setGroup(Sextante.getText((String)"Analisis_hidrologico_basico"));
        this.setGeneratesUserDefinedRasterOutput(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.m_Parameters.addInputRasterLayer(NETWORK, Sextante.getText((String)"Red_de_drenaje"), true);
            this.m_Parameters.addNumericalValue(MINSIZE, Sextante.getText((String)"Tamano_minimo_de_subcuenca_celdas"), 0.0, 1);
            this.addOutputRasterLayer(WATERSHEDS, Sextante.getText((String)"Cuencas"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateBasins() {
        this.prepareDirectionsLayer();
        ArrayList outletsArrayList = this.getOutlets();
        Object[] outlets = outletsArrayList.toArray();
        Arrays.sort(outlets);
        this.m_iBasins = 0;
        int i = outlets.length - 1;
        while (i >= 0 && this.setProgress(outlets.length - i, outlets.length)) {
            int y;
            ++this.m_iBasins;
            int x = ((GridCell)outlets[i]).getX();
            if (this.getBasin(x, y = ((GridCell)outlets[i]).getY()) < this.m_iMinSize) {
                int iBasins = this.m_iBasins - 1;
                this.m_iBasins = -1;
                this.getBasin(x, y);
                this.m_iBasins = iBasins;
            }
            --i;
        }
    }

    private void prepareDirectionsLayer() {
        int y = 0;
        while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
            int x = 0;
            while (x < this.m_iNX) {
                int iDir = this.m_DEM.getDirToNextDownslopeCell(x, y, false);
                if (iDir < 0) {
                    this.m_Directions.setCellValue(x, y, -1.0);
                } else {
                    this.m_Directions.setCellValue(x, y, (double)((iDir + 4) % 8));
                }
                ++x;
            }
            ++y;
        }
    }

    private ArrayList getOutlets() {
        ArrayList outlets = new ArrayList();
        int y = 0;
        while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
            int x = 0;
            while (x < this.m_iNX) {
                this.addOutlet(x, y, outlets);
                ++x;
            }
            ++y;
        }
        return outlets;
    }

    private void addOutlet(int x, int y, ArrayList outlets) {
        int iUpslopeX = 0;
        int iUpslopeY = 0;
        int iUpslopeRiverCells = 0;
        double dUpslopeZ = 0.0;
        int iNetwork = this.m_Network.getCellValueAsInt(x, y);
        int iDir = this.m_Directions.getCellValueAsInt(x, y);
        double dZ = this.m_DEM.getCellValueAsDouble(x, y);
        if (this.m_Network.isNoDataValue((double)iNetwork) || iNetwork == 0) {
            return;
        }
        if (iNetwork < 0) {
            outlets.add(new GridCell(x, y, dZ));
            return;
        }
        if (iDir == -1 && !this.m_DEM.isNoDataValue(dZ)) {
            outlets.add(new GridCell(x, y, dZ));
        } else {
            int i = 0;
            while (i < 8) {
                int ix = x + m_iOffsetX[i];
                int iy = y + m_iOffsetY[i];
                if (this.m_Directions.getCellValueAsInt(ix, iy) == i && (iNetwork = this.m_Network.getCellValueAsInt(ix, iy)) > 0 && !this.m_Network.isNoDataValue((double)iNetwork)) {
                    if (iUpslopeRiverCells > 0) {
                        if (iUpslopeRiverCells == 1) {
                            outlets.add(new GridCell(iUpslopeX, iUpslopeY, dUpslopeZ));
                        }
                        outlets.add(new GridCell(ix, iy, this.m_DEM.getCellValueAsDouble(ix, iy)));
                    } else {
                        iUpslopeX = ix;
                        iUpslopeY = iy;
                        dUpslopeZ = this.m_DEM.getCellValueAsDouble(x, y);
                    }
                    ++iUpslopeRiverCells;
                }
                ++i;
            }
        }
    }

    private int getBasin(int x, int y) {
        int nCells = 1;
        int iBasin = this.m_Basins.getCellValueAsInt(x, y);
        int iDir = this.m_Directions.getCellValueAsInt(x, y);
        if (iBasin == -1 && !this.m_Directions.isNoDataValue((double)iDir)) {
            this.m_Basins.setCellValue(x, y, (double)this.m_iBasins);
            int i = 0;
            nCells = 1;
            while (i < 8) {
                int ix = x + m_iOffsetX[i];
                int iy = y + m_iOffsetY[i];
                if (this.m_Directions.getCellValueAsInt(ix, iy) == i && this.m_Basins.getCellValueAsInt(ix, iy) == -1) {
                    nCells += this.getBasin(ix, iy);
                }
                ++i;
            }
            return nCells;
        }
        return 0;
    }
}

