/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.watershedsBySize;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.hydrology.accFlow.AccFlowAlgorithm;
import es.unex.sextante.hydrology.watersheds.WatershedsAlgorithm;
import es.unex.sextante.outputs.Output;

public class WatershedsBySizeAlgorithm
extends GeoAlgorithm {
    public static final String WATERSHEDS = "WATERSHEDS";
    public static final String SIZE = "SIZE";
    public static final String DEM = "DEM";
    private static final int[] m_iOffsetX;
    private static final int[] m_iOffsetY;
    private int m_iNX;
    private int m_iNY;
    private double m_dSize;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Outlets;
    private IRasterLayer m_FlowAcc;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        m_iOffsetX = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        m_iOffsetY = nArray2;
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Cuencas_por_tamano"));
        this.setGeneratesUserDefinedRasterOutput(false);
        this.setGroup(Sextante.getText((String)"Analisis_hidrologico_basico"));
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"mde"), true);
            this.m_Parameters.addNumericalValue(SIZE, Sextante.getText((String)"Tamano"), 2, 10000.0, 0.0, Double.MAX_VALUE);
            this.addOutputRasterLayer(WATERSHEDS, Sextante.getText((String)"Cuencas"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_DEM.setFullExtent();
        this.m_dSize = this.m_Parameters.getParameterValueAsDouble(SIZE);
        this.m_Outlets = this.getTempRasterLayer(3, this.m_DEM.getWindowGridExtent());
        this.m_Outlets.setNoDataValue(0.0);
        this.m_Outlets.assignNoData();
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        if (!this.calculateAccFlow()) {
            return false;
        }
        this.calculateOutlets();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        return this.calculateWatersheds();
    }

    private boolean calculateWatersheds() throws GeoAlgorithmExecutionException {
        try {
            this.setProgress(0, 100);
            this.setProgressText("3/3");
            WatershedsAlgorithm alg = new WatershedsAlgorithm();
            ParametersSet params = alg.getParameters();
            params.getParameter(DEM).setParameterValue((Object)this.m_DEM);
            params.getParameter("NETWORK").setParameterValue((Object)this.m_Outlets);
            OutputObjectsSet oo = alg.getOutputObjects();
            Output output = oo.getOutput(WATERSHEDS);
            output.setOutputChannel(this.getOutputChannel(WATERSHEDS));
            boolean bSucess = alg.execute(this.m_Task, this.m_OutputFactory);
            if (bSucess) {
                output = oo.getOutput(WATERSHEDS);
                this.m_OutputObjects.getOutput(WATERSHEDS).setOutputObject(output.getOutputObject());
                this.m_OutputObjects.getOutput(WATERSHEDS).setOutputChannel(output.getOutputChannel());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
    }

    private boolean calculateAccFlow() throws GeoAlgorithmExecutionException {
        try {
            this.setProgressText("1/3");
            AccFlowAlgorithm alg = new AccFlowAlgorithm();
            ParametersSet params = alg.getParameters();
            params.getParameter("METHOD").setParameterValue((Object)0);
            params.getParameter(DEM).setParameterValue((Object)this.m_DEM);
            if (alg.execute(this.m_Task, this.m_OutputFactory)) {
                this.m_FlowAcc = (IRasterLayer)alg.getOutputObjects().getOutput("FLOWACC").getOutputObject();
                this.m_FlowAcc.open();
                this.m_FlowAcc.setFullExtent();
                this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
                this.m_DEM.open();
                this.m_DEM.setFullExtent();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
    }

    private void calculateOutlets() {
        this.setProgressText("2/3");
        int x = 0;
        while (x < this.m_iNX && this.setProgress(x, this.m_iNX)) {
            int y = 0;
            while (y < this.m_iNY) {
                double dValue = this.m_FlowAcc.getCellValueAsDouble(x, y);
                if (!this.m_FlowAcc.isNoDataValue(dValue)) {
                    this.setOutlet(x, y);
                }
                ++y;
            }
            ++x;
        }
    }

    private void setOutlet(int x, int y) {
        double dValue = this.m_FlowAcc.getCellValueAsDouble(x, y);
        int iValue = (int)(dValue / this.m_dSize);
        int i = 0;
        while (i < 8) {
            int iValue2;
            int iDirection;
            int ix = x + m_iOffsetX[i];
            int iy = y + m_iOffsetY[i];
            dValue = this.m_DEM.getCellValueAsDouble(ix, iy);
            if (!this.m_DEM.isNoDataValue(dValue) && (iDirection = this.m_DEM.getDirToNextDownslopeCell(ix, iy)) >= 0 && (i + 4) % 8 == iDirection && iValue != (iValue2 = (int)(this.m_FlowAcc.getCellValueAsDouble(ix, iy) / this.m_dSize))) {
                this.m_Outlets.setCellValue(ix, iy, -1.0);
            }
            ++i;
        }
    }
}

