package org.finconsgroup.itserr.criterion.common.http.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

@Data
@ConfigurationProperties(prefix = "wp3.http-client")
public class PropagatingRestTemplateProperties {

    private boolean enabled = true;
    private Duration connectTimeout = Duration.ofSeconds(5);
    private Duration readTimeout = Duration.ofSeconds(30);

    /**
     * Headers to propagate from incoming request to outgoing calls.
     */
    private List<String> propagateHeaders = new ArrayList<>(List.of(
            "Authorization",
            "X-Correlation-ID",
            "X-Request-ID"
    ));

    /**
     * Internal auth configuration - adds header to skip external auth check
     * on receiving microservice.
     */
    private InternalAuthProperties internal = new InternalAuthProperties();

    @Data
    public static class InternalAuthProperties {

        /**
         * Enable adding internal auth header to outgoing requests.
         */
        private boolean enabled = true;

        /**
         * Header name for internal authentication.
         */
        private String headerName = "X-Internal-Auth";

        /**
         * Shared secret - MUST match the secret in wp3.external-auth.internal.secret
         */
        private String secret;
    }
}