/*
 * Decompiled with CFR 0.152.
 */
package org.finconsgroup.itserr.criterion.common.http.config;

import lombok.Generated;
import org.finconsgroup.itserr.criterion.common.http.config.PropagatingRestTemplateProperties;
import org.finconsgroup.itserr.criterion.common.http.interceptor.HeaderPropagatingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@EnableConfigurationProperties(value={PropagatingRestTemplateProperties.class})
@ConditionalOnProperty(prefix="wp3.http-client", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class PropagatingRestTemplateAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropagatingRestTemplateAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"internalRestTemplate"})
    public RestTemplate internalRestTemplate(ObjectProvider<RestTemplateBuilder> builderProvider, PropagatingRestTemplateProperties properties) {
        RestTemplate restTemplate;
        log.info("Creating InternalRestTemplate with header propagation and internal auth");
        RestTemplateBuilder builder = (RestTemplateBuilder)builderProvider.getIfAvailable();
        if (builder != null) {
            restTemplate = builder.connectTimeout(properties.getConnectTimeout()).readTimeout(properties.getReadTimeout()).build();
        } else {
            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
            factory.setConnectTimeout((int)properties.getConnectTimeout().toMillis());
            factory.setReadTimeout((int)properties.getReadTimeout().toMillis());
            restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        }
        restTemplate.getInterceptors().add(new HeaderPropagatingInterceptor(properties));
        return restTemplate;
    }
}

