package org.finconsgroup.itserr.criterion.common.dto;


import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.UUID;

/**
 * Data Transfer Object for NotificationEntity
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class NotificationDto {

    private UUID notificationId;
    @NotNull
    private UUID notificationOwnerId;
    private UUID documentOwnerId;
    private UUID documentId;
    private UUID recipientUserId;
    @NotNull
    private Integer notificationEventId;
    @NotBlank
    @Size(max = 100)
    private String notificationTitle;
    @Size(max = 255)
    private String ownerMessage;
    @Size(max = 255)
    private String recipientMessage;
    private LocalDateTime viewedDate;
    private LocalDateTime creationDate;
    private Boolean emailSend;
}
