/*
 * Decompiled with CFR 0.152.
 */
package org.finconsgroup.itserr.criterion.security.config;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.finconsgroup.itserr.criterion.security.aspect.ExternalAuthAspect;
import org.finconsgroup.itserr.criterion.security.config.ExternalAuthProperties;
import org.finconsgroup.itserr.criterion.security.service.ExternalAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@EnableConfigurationProperties(value={ExternalAuthProperties.class})
@ConditionalOnProperty(prefix="wp3.external-auth", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ExternalAuthAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalAuthAutoConfiguration.class);
    public static final String CIRCUIT_BREAKER_NAME = "externalAuth";
    public static final String RETRY_NAME = "externalAuth";

    @Bean
    @ConditionalOnMissingBean(name={"externalAuthRestTemplate"})
    public RestTemplate externalAuthRestTemplate(ObjectProvider<RestTemplateBuilder> restTemplateBuilderProvider, ExternalAuthProperties properties) {
        log.debug("Creating RestTemplate with connectTimeout={}, readTimeout={}", (Object)properties.getConnectTimeout(), (Object)properties.getReadTimeout());
        RestTemplateBuilder builder = (RestTemplateBuilder)restTemplateBuilderProvider.getIfAvailable();
        if (builder != null) {
            return builder.connectTimeout(properties.getConnectTimeout()).readTimeout(properties.getReadTimeout()).build();
        }
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setConnectTimeout((int)properties.getConnectTimeout().toMillis());
        factory.setReadTimeout((int)properties.getReadTimeout().toMillis());
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean
    @ConditionalOnMissingBean
    public CircuitBreakerRegistry externalAuthCircuitBreakerRegistry(ExternalAuthProperties properties) {
        ExternalAuthProperties.CircuitBreakerProperties cbProps = properties.getCircuitBreaker();
        CircuitBreakerConfig config = CircuitBreakerConfig.custom().failureRateThreshold(cbProps.getFailureRateThreshold()).waitDurationInOpenState(cbProps.getWaitDurationInOpenState()).permittedNumberOfCallsInHalfOpenState(cbProps.getPermittedNumberOfCallsInHalfOpenState()).slidingWindowSize(cbProps.getSlidingWindowSize()).minimumNumberOfCalls(cbProps.getMinimumNumberOfCalls()).recordExceptions(new Class[]{ResourceAccessException.class, ConnectException.class, SocketTimeoutException.class, TimeoutException.class, IOException.class}).build();
        return CircuitBreakerRegistry.of((CircuitBreakerConfig)config);
    }

    @Bean
    @ConditionalOnMissingBean
    public RetryRegistry externalAuthRetryRegistry(ExternalAuthProperties properties) {
        ExternalAuthProperties.RetryProperties retryProps = properties.getRetry();
        RetryConfig config = RetryConfig.custom().maxAttempts(retryProps.getMaxAttempts()).waitDuration(retryProps.getWaitDuration()).intervalFunction(attempt -> Math.min((long)((double)retryProps.getWaitDuration().toMillis() * Math.pow(retryProps.getMultiplier(), attempt - 1)), retryProps.getMaxWaitDuration().toMillis())).retryExceptions(new Class[]{ResourceAccessException.class, ConnectException.class, SocketTimeoutException.class, TimeoutException.class, IOException.class}).build();
        return RetryRegistry.of((RetryConfig)config);
    }

    @Bean
    public CircuitBreaker externalAuthCircuitBreaker(CircuitBreakerRegistry registry) {
        CircuitBreaker circuitBreaker = registry.circuitBreaker("externalAuth");
        circuitBreaker.getEventPublisher().onStateTransition(event -> log.warn("Circuit Breaker '{}' state changed: {} -> {}", new Object[]{"externalAuth", event.getStateTransition().getFromState(), event.getStateTransition().getToState()})).onFailureRateExceeded(event -> log.warn("Circuit Breaker '{}' failure rate exceeded: {}%", (Object)"externalAuth", (Object)Float.valueOf(event.getFailureRate()))).onCallNotPermitted(event -> log.warn("Circuit Breaker '{}' rejected call - circuit is OPEN", (Object)"externalAuth"));
        return circuitBreaker;
    }

    @Bean
    public Retry externalAuthRetry(RetryRegistry registry) {
        Retry retry = registry.retry("externalAuth");
        retry.getEventPublisher().onRetry(event -> log.warn("Retry '{}' attempt #{} failed, waiting before next attempt...", (Object)"externalAuth", (Object)event.getNumberOfRetryAttempts())).onError(event -> log.error("Retry '{}' exhausted after {} attempts", (Object)"externalAuth", (Object)event.getNumberOfRetryAttempts()));
        return retry;
    }

    @Bean
    @ConditionalOnMissingBean
    public ExternalAuthService externalAuthService(@Qualifier(value="externalAuthRestTemplate") RestTemplate externalAuthRestTemplate, ExternalAuthProperties properties, CircuitBreaker externalAuthCircuitBreaker, Retry externalAuthRetry) {
        return new ExternalAuthService(externalAuthRestTemplate, properties, externalAuthCircuitBreaker, externalAuthRetry);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExternalAuthAspect externalAuthAspect(ExternalAuthService externalAuthService, ExternalAuthProperties properties) {
        log.info("External Auth ENABLED - URL: {}, FailOpen: {}", (Object)properties.getUrl(), (Object)properties.isFailOpen());
        return new ExternalAuthAspect(externalAuthService, properties);
    }
}

