/*
 * Decompiled with CFR 0.152.
 */
package org.finconsgroup.itserr.criterion.security.health;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import org.finconsgroup.itserr.criterion.security.service.ExternalAuthService;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class ExternalAuthHealthIndicator
implements HealthIndicator {
    private final ExternalAuthService externalAuthService;

    public ExternalAuthHealthIndicator(ExternalAuthService externalAuthService) {
        this.externalAuthService = externalAuthService;
    }

    public Health health() {
        CircuitBreaker.State state = this.externalAuthService.getCircuitBreakerState();
        CircuitBreaker.Metrics metrics = this.externalAuthService.getCircuitBreakerMetrics();
        Health.Builder builder = switch (state) {
            default -> throw new MatchException(null, null);
            case CircuitBreaker.State.CLOSED -> Health.up();
            case CircuitBreaker.State.HALF_OPEN -> Health.unknown();
            case CircuitBreaker.State.OPEN, CircuitBreaker.State.DISABLED, CircuitBreaker.State.FORCED_OPEN, CircuitBreaker.State.METRICS_ONLY -> Health.down();
        };
        return builder.withDetail("circuitBreakerState", (Object)state.name()).withDetail("failureRate", (Object)String.format("%.2f%%", Float.valueOf(metrics.getFailureRate()))).withDetail("successfulCalls", (Object)metrics.getNumberOfSuccessfulCalls()).withDetail("failedCalls", (Object)metrics.getNumberOfFailedCalls()).withDetail("notPermittedCalls", (Object)metrics.getNumberOfNotPermittedCalls()).withDetail("bufferedCalls", (Object)metrics.getNumberOfBufferedCalls()).build();
    }
}

