package com.finconsgroup.itserr.marketplace.metadata.integration.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.metadata.integration.client.metadatadm.MetadataLibsMetadataDmClient;
import com.finconsgroup.itserr.marketplace.metadata.integration.client.metadatadm.dto.OutputMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.integration.exception.WP2InvalidMetadataException;
import com.finconsgroup.itserr.marketplace.metadata.integration.exception.WP2MetadataNotFoundException;
import com.finconsgroup.itserr.marketplace.metadata.integration.exception.WP2MetadataRetrieveException;
import com.finconsgroup.itserr.marketplace.metadata.integration.mapper.FieldMapper;
import com.finconsgroup.itserr.marketplace.metadata.integration.service.MetadataValidationService;
import com.finconsgroup.itserr.marketplace.metadata.lib.ConstraintViolation;
import com.finconsgroup.itserr.marketplace.metadata.lib.MetadataValidator;
import com.finconsgroup.itserr.marketplace.metadata.lib.bean.Field;
import com.finconsgroup.itserr.marketplace.metadata.lib.validation.field.FieldValidator;
import lombok.RequiredArgsConstructor;
import org.springframework.lang.NonNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

/**
 * Default implementation of a {@link MetadataValidationService}.
 */
@RequiredArgsConstructor
public class DefaultMetadataValidationService implements MetadataValidationService {

    private final List<FieldValidator> fieldValidators;

    private final MetadataLibsMetadataDmClient client;

    private final FieldMapper fieldMapper;

    @Override
    @NonNull
    public List<ConstraintViolation> validate(
            @NonNull final UUID metadataId,
            @NonNull final Map<String, Object> values) {

        // Retrieve metadata
        final OutputMetadataDmDto metadata;
        try {
            metadata = client.findById(metadataId);
        } catch (final WP2ResourceNotFoundException e) {
            throw new WP2MetadataNotFoundException(e);
        } catch (final Exception e) {
            throw new WP2MetadataRetrieveException(e);
        }

        // Get fields
        final List<Field> fields = Optional.ofNullable(metadata.getFields())
                .orElseGet(ArrayList::new)
                .stream()
                .map(fieldMapper::clientFieldToField)
                .toList();

        // validate
        final MetadataValidator validator = new MetadataValidator(
                fields,
                fieldValidators);
        return validator.validate(values);

    }

    @Override
    public void validateOrThrow(
            @NonNull final UUID metadataId,
            @NonNull final Map<String, Object> values) {

        final List<ConstraintViolation> metadataViolations = this.validate(
                metadataId,
                values);
        if (!metadataViolations.isEmpty()) {
            throw new WP2InvalidMetadataException(metadataViolations);
        }

    }
    
}
