package com.finconsgroup.itserr.marketplace.audit.bs.service;

import com.finconsgroup.itserr.marketplace.audit.bs.dto.InputCreateAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.bs.dto.OutputAuditLogDto;
import com.finconsgroup.itserr.messaging.dto.UntypedMessagingEventDto;
import io.cloudevents.CloudEvent;
import org.springframework.lang.NonNull;

/**
 * Service for handling business logic related to AuditLog. This interface provides methods to retrieve, create, update, and delete AuditLog,
 *
 * <p>Example usage:
 * <pre>
 * Page<OutputAuditLogDto> AuditLog = AuditLogService.findAll(pageable);
 * </pre>
 * </p>
 */
public interface AuditLogService {

    /**
     * Creates new AuditLog for user using the provided input data.
     *
     * @param inputCreateAuditLogDto the input DTO containing AuditLog details
     */
    @NonNull
    OutputAuditLogDto create(@NonNull InputCreateAuditLogDto inputCreateAuditLogDto);

    /**
     * Creates new audit log using the provided input data.
     *
     * @param messagingEventDto the input messaging event DTO containing audit log details
     */
    @NonNull
    OutputAuditLogDto createFromMessagingEvent(@NonNull UntypedMessagingEventDto messagingEventDto,
                                               @NonNull CloudEvent cloudEvent);

}
