package com.finconsgroup.itserr.marketplace.audit.dm.validation;

import com.finconsgroup.itserr.marketplace.audit.dm.validation.annotation.InputCreateAuditLogDtoValidator;
import jakarta.validation.Constraint;
import jakarta.validation.Payload;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to enable the validation for {@link com.finconsgroup.itserr.marketplace.audit.dm.dto.InputAuditLogUserDto}
 */
@Target({ElementType.PARAMETER, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = {InputCreateAuditLogDtoValidator.class})
@Documented
public @interface ValidInputCreateAuditLogDto {
    String message() default "";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
