/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.controller;

import com.finconsgroup.itserr.marketplace.discussion.bs.api.DiscussionApi;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.InputUpdateDiscussionDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ReactionType;
import com.finconsgroup.itserr.marketplace.discussion.bs.service.DiscussionService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DiscussionController
implements DiscussionApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiscussionController.class);
    private final DiscussionService discussionService;

    public Page<DiscussionDTO> getDiscussions(int page, int size, String sortBy, String direction, String visibility, boolean includeThreads) {
        return this.discussionService.getDiscussions(page, size, sortBy, direction, visibility, includeThreads);
    }

    public ResponseEntity<Void> createDiscussion(DiscussionDTO discussionDTO) {
        return this.discussionService.createDiscussion(discussionDTO);
    }

    public ResponseEntity<DiscussionDTO> updateDiscussion(String id, InputUpdateDiscussionDto discussionDto) {
        log.info("PATCH discussion with id: {}", (Object)id);
        DiscussionDTO discussionDTO = this.discussionService.updateDiscussion(id, discussionDto);
        return new ResponseEntity((Object)discussionDTO, (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<Void> deleteDiscussion(String id) {
        return this.discussionService.deleteDiscussion(id);
    }

    public Page<ThreadDTO> getThreadsByDiscussionId(String discussionId, int page, int size, String sortBy, Sort.Direction direction) {
        return this.discussionService.getThreadsByDiscussionId(discussionId, page, size, sortBy, direction);
    }

    public ResponseEntity<ThreadDTO> addThread(String discussionId, ThreadDTO threadDTO) {
        return this.discussionService.addThread(discussionId, threadDTO);
    }

    public ResponseEntity<Void> deleteThread(String discussionId, String threadId) {
        return this.discussionService.deleteThread(discussionId, threadId);
    }

    public ResponseEntity<ThreadDTO> updateThread(String discussionId, String threadId, ThreadDTO threadDTO) {
        return this.discussionService.updateThread(discussionId, threadId, threadDTO);
    }

    public ResponseEntity<Void> addReactionToDiscussion(String discussionId, String userId, ReactionType reactionType) {
        return this.discussionService.addReactionToDiscussion(discussionId, userId, reactionType);
    }

    public ResponseEntity<Void> removeReactionFromDiscussion(String discussionId, String userId) {
        return this.discussionService.removeReactionFromDiscussion(discussionId, userId);
    }

    public ResponseEntity<Void> addReactionToThread(String discussionId, String threadId, String userId, ReactionType reactionType) {
        return this.discussionService.addReactionToThread(discussionId, threadId, userId, reactionType);
    }

    public ResponseEntity<Void> removeReactionFromThread(String discussionId, String threadId, String userId) {
        return this.discussionService.removeReactionFromThread(discussionId, threadId, userId);
    }

    public DiscussionDTO getDiscussionByResourceId(String resourceId) {
        return this.discussionService.getDiscussionByResourceId(resourceId);
    }

    @Generated
    public DiscussionController(DiscussionService discussionService) {
        this.discussionService = discussionService;
    }
}

