/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.api;

import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.InputUpdateDiscussionDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ReactionType;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="Discussion Management", description="API for managing discussions, threads, and reactions in the ITSERR marketplace")
@SecurityRequirement(name="BearerAuth")
public interface DiscussionApi {
    @Operation(summary="Get paginated discussions", description="Retrieves a paginated list of discussions with sorting and filtering options")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Discussions retrieved successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=Page.class))}), @ApiResponse(responseCode="400", description="Invalid pagination or sorting parameters"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @GetMapping(value={"/discussions"})
    public Page<DiscussionDTO> getDiscussions(@Parameter(description="Page number (0-based)", example="0") @RequestParam(defaultValue="0") int var1, @Parameter(description="Number of items per page", example="10") @RequestParam(defaultValue="10") int var2, @Parameter(description="Field to sort by", example="createdAt") @RequestParam(defaultValue="createdAt") String var3, @Parameter(description="Sort direction (asc or desc)", example="desc") @RequestParam(defaultValue="desc") String var4, @Parameter(description="Filter by visibility (optional)", example="public") @RequestParam(required=false) String var5, @Parameter(description="Include threads in response (default: true)", example="true") @RequestParam(defaultValue="true") boolean var6);

    @Operation(summary="Create new discussion", description="Creates a new discussion with the provided data")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Discussion created successfully"), @ApiResponse(responseCode="400", description="Invalid discussion data"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @PostMapping(value={"/discussion"})
    public ResponseEntity<Void> createDiscussion(@io.swagger.v3.oas.annotations.parameters.RequestBody(description="Discussion data to create", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=DiscussionDTO.class))}) @RequestBody DiscussionDTO var1);

    @Operation(summary="Update discussion", description="Updates an existing discussion with new details")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Discussion updated successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=DiscussionDTO.class))}), @ApiResponse(responseCode="400", description="Invalid discussion data"), @ApiResponse(responseCode="404", description="Discussion not found"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @PatchMapping(value={"/discussion/{id}"})
    public ResponseEntity<DiscussionDTO> updateDiscussion(@Parameter(description="The unique identifier of the discussion to update", required=true) @PathVariable String var1, @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Updated discussion data", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=InputUpdateDiscussionDto.class))}) @RequestBody InputUpdateDiscussionDto var2);

    @Operation(summary="Delete discussion", description="Deletes a discussion by its unique identifier")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Discussion deleted successfully"), @ApiResponse(responseCode="404", description="Discussion not found"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @DeleteMapping(value={"/discussion/{id}"})
    public ResponseEntity<Void> deleteDiscussion(@Parameter(description="The unique identifier of the discussion to delete", required=true) @PathVariable String var1);

    @GetMapping(value={"/discussion/{discussionId}/threads"})
    public Page<ThreadDTO> getThreadsByDiscussionId(@Parameter(description="The unique identifier of the discussion", required=true) @PathVariable String var1, @Parameter(description="Page number (0-based)", example="0") @RequestParam(defaultValue="0") int var2, @Parameter(description="Number of items per page", example="10") @RequestParam(defaultValue="10") int var3, @Parameter(description="Field to sort by", example="createdAt") @RequestParam(defaultValue="createdAt") String var4, @Parameter(description="Sort direction (ASC or DESC)", example="DESC") @RequestParam(defaultValue="DESC") Sort.Direction var5);

    @Operation(summary="Add thread to discussion", description="Adds a new thread to an existing discussion")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Thread added successfully"), @ApiResponse(responseCode="400", description="Invalid thread data"), @ApiResponse(responseCode="404", description="Discussion not found"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @PostMapping(value={"/discussion/{discussionId}/threads"})
    public ResponseEntity<ThreadDTO> addThread(@Parameter(description="The unique identifier of the discussion", required=true) @PathVariable String var1, @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Thread data to add", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=ThreadDTO.class))}) @RequestBody ThreadDTO var2);

    @Operation(summary="Delete thread from discussion", description="Deletes a specific thread from a discussion")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Thread deleted successfully"), @ApiResponse(responseCode="404", description="Discussion or thread not found"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @DeleteMapping(value={"/discussion/{discussionId}/threads/{threadId}"})
    public ResponseEntity<Void> deleteThread(@Parameter(description="The unique identifier of the discussion", required=true) @PathVariable String var1, @Parameter(description="The unique identifier of the thread to delete", required=true) @PathVariable String var2);

    @Operation(summary="Update thread in discussion", description="Updates a specific thread within a discussion")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Thread updated successfully"), @ApiResponse(responseCode="404", description="Discussion or thread not found"), @ApiResponse(responseCode="400", description="Invalid thread data"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @PutMapping(value={"/discussion/{discussionId}/threads/{threadId}"})
    public ResponseEntity<ThreadDTO> updateThread(@Parameter(description="The unique identifier of the discussion", required=true) @PathVariable String var1, @Parameter(description="The unique identifier of the thread to update", required=true) @PathVariable String var2, @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Thread data to update", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=ThreadDTO.class))}) @RequestBody ThreadDTO var3);

    @Operation(summary="Add reaction to discussion", description="Adds a reaction to a discussion by a user")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Reaction added successfully"), @ApiResponse(responseCode="404", description="Discussion not found"), @ApiResponse(responseCode="409", description="Reaction already exists"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @PostMapping(value={"/discussion/{discussionId}/reactions/{userId}"})
    public ResponseEntity<Void> addReactionToDiscussion(@Parameter(description="The unique identifier of the discussion", required=true) @PathVariable String var1, @Parameter(description="The unique identifier of the user", required=true) @PathVariable String var2, @Parameter(description="The type of reaction to add", required=true) @RequestParam ReactionType var3);

    @Operation(summary="Remove reaction from discussion", description="Removes a reaction from a discussion by a user")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Reaction removed successfully"), @ApiResponse(responseCode="404", description="Discussion or reaction not found"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @DeleteMapping(value={"/discussion/{discussionId}/reactions/{userId}"})
    public ResponseEntity<Void> removeReactionFromDiscussion(@Parameter(description="The unique identifier of the discussion", required=true) @PathVariable String var1, @Parameter(description="The unique identifier of the user", required=true) @PathVariable String var2);

    @Operation(summary="Add reaction to thread", description="Adds a reaction to a specific thread within a discussion")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Reaction added successfully"), @ApiResponse(responseCode="404", description="Discussion or thread not found"), @ApiResponse(responseCode="409", description="Reaction already exists"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @PostMapping(value={"/discussion/{discussionId}/threads/{threadId}/reactions/{userId}"})
    public ResponseEntity<Void> addReactionToThread(@Parameter(description="The unique identifier of the discussion", required=true) @PathVariable String var1, @Parameter(description="The unique identifier of the thread", required=true) @PathVariable String var2, @Parameter(description="The unique identifier of the user", required=true) @PathVariable String var3, @Parameter(description="The type of reaction to add", required=true) @RequestParam ReactionType var4);

    @Operation(summary="Remove reaction from thread", description="Removes a reaction from a specific thread within a discussion")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Reaction removed successfully"), @ApiResponse(responseCode="404", description="Discussion, thread, or reaction not found"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @DeleteMapping(value={"/discussion/{discussionId}/threads/{threadId}/reactions/{userId}"})
    public ResponseEntity<Void> removeReactionFromThread(@Parameter(description="The unique identifier of the discussion", required=true) @PathVariable String var1, @Parameter(description="The unique identifier of the thread", required=true) @PathVariable String var2, @Parameter(description="The unique identifier of the user", required=true) @PathVariable String var3);

    @Operation(summary="Get discussion by resource ID", description="Retrieves a discussion associated with the specified resource identifier")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Discussion found successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=DiscussionDTO.class))}), @ApiResponse(responseCode="404", description="Discussion not found"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @GetMapping(value={"/discussion/resource/{resourceId}"})
    public DiscussionDTO getDiscussionByResourceId(@Parameter(description="The unique identifier of the resource", required=true) @PathVariable String var1);
}

