package com.finconsgroup.itserr.marketplace.discussion.bs.messaging;

import com.finconsgroup.itserr.marketplace.discussion.bs.config.properties.DocumentsProperties;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ResourceType;
import com.finconsgroup.itserr.messaging.consumer.AbstractResourceSubscriber;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Component("documentCreationSubscriber")
@RequiredArgsConstructor
@Slf4j
public class DocumentCreationSubscriber extends AbstractResourceSubscriber {
    private final CreationDiscussionUtility creationDiscussionUtility;
    private final DocumentsProperties documentsProperties;


    @Override
    protected void handleResource(String id, Object eventData, String eventType) {
        if (Objects.equals(eventType, documentsProperties.getResourceCreatedEventType())) {
            creationDiscussionUtility.create(id, eventData, ResourceType.DOCUMENT.getValue());
        }
    }
}
