package com.finconsgroup.itserr.marketplace.discussion.bs.enums;

public enum ResourceType {
    NEWS("news"),
    INSTITUTIONAL_PAGE("institutionalPage"),
    EVENT("event"),
    ITEM("item"),
    FOLDER("folder"),
    DOCUMENT("document");

    private final String value;

    ResourceType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static ResourceType fromValue(String value) {
        for (ResourceType type : ResourceType.values()) {
            if (type.value.equals(value)) {
                return type;
            }
        }
        throw new IllegalArgumentException("Unknown resource type: " + value);
    }

    @Override
    public String toString() {
        return value;
    }
}
