package com.finconsgroup.itserr.marketplace.discussion.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Data Transfer Object for updating a Discussion entity.
 * This DTO is used for partial updates (PATCH operations).
 * All fields are optional, only provided fields will be updated.
 */
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class InputUpdateDiscussionDto {

    /**
     * The updated title of the discussion.
     * Optional field for partial updates.
     */
    @Size(max = 255, message = "Title must not exceed 255 characters")
    @Schema(description = "The updated title of the discussion", example = "Updated Discussion Title")
    private String title;

    /**
     * The updated textual content of the discussion.
     * Optional field for partial updates.
     */
    @Schema(description = "The updated content of the discussion", example = "Updated discussion content")
    private String content;

    /**
     * The updated URL associated with the discussion.
     * Optional field for partial updates.
     */
    @Size(max = 500, message = "URL must not exceed 500 characters")
    @Schema(description = "The updated URL associated with the discussion", example = "https://example.com/updated")
    private String url;
}