/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.component;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.discussion.bs.bean.DiscussionThreadApplicationEvent;
import com.finconsgroup.itserr.marketplace.discussion.bs.bean.DiscussionThreadDetails;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.MessagingEventType;
import com.finconsgroup.itserr.marketplace.discussion.bs.mapper.EventToDiscussionMapper;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto.DiscussionThreadMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer.EventProducer;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer.ResourceProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MessagingDiscussionThreadApplicationEventListener
implements ApplicationListener<DiscussionThreadApplicationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingDiscussionThreadApplicationEventListener.class);
    private final ResourceProducer resourceProducer;
    private final EventProducer eventProducer;
    private final EventToDiscussionMapper eventToDiscussionMapper;

    public void onApplicationEvent(@NonNull DiscussionThreadApplicationEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        MessagingEventDto messagingEventDto = this.eventToDiscussionMapper.toMessagingEventDto(event.getDiscussionThreadDetails());
        MessagingEventUserDto user = MessagingEventUserDto.builder().id((UUID)JwtTokenHolder.getUserId().orElse(null)).name((String)JwtTokenHolder.getName().orElse(null)).username((String)JwtTokenHolder.getPreferredUsername().orElse(null)).build();
        messagingEventDto.setUser(user);
        DiscussionThreadMessagingAdditionalDataDto additionalData = MessagingDiscussionThreadApplicationEventListener.getDiscussionThreadMessagingAdditionalDataDto((DiscussionThreadApplicationEvent)event);
        messagingEventDto.setAdditionalData((Object)additionalData);
        this.publishEventForType(event, messagingEventDto);
    }

    @NotNull
    private static DiscussionThreadMessagingAdditionalDataDto getDiscussionThreadMessagingAdditionalDataDto(@NotNull DiscussionThreadApplicationEvent event) {
        DiscussionThreadDetails discussionThreadDetails = event.getDiscussionThreadDetails();
        DiscussionThreadMessagingAdditionalDataDto additionalData = new DiscussionThreadMessagingAdditionalDataDto();
        additionalData.setDiscussionResourceId(discussionThreadDetails.getDiscussionResourceId());
        additionalData.setDiscussionResourceType(discussionThreadDetails.getDiscussionResourceType());
        additionalData.setNotifyUserIds(discussionThreadDetails.getUsersToNotify());
        additionalData.setDiscussionId(discussionThreadDetails.getDiscussionId());
        additionalData.setDiscussionTitle(discussionThreadDetails.getDiscussionTitle());
        return additionalData;
    }

    private void publishEventForType(DiscussionThreadApplicationEvent applicationEvent, MessagingEventDto<DiscussionThreadMessagingAdditionalDataDto> messagingEventDto) {
        if (applicationEvent.getEventType() == MessagingEventType.THREAD_CREATED) {
            this.resourceProducer.publishUpdatedResource(applicationEvent.getDiscussion());
            this.eventProducer.publishThreadCreatedEvent(messagingEventDto);
        }
    }

    @Generated
    public MessagingDiscussionThreadApplicationEventListener(ResourceProducer resourceProducer, EventProducer eventProducer, EventToDiscussionMapper eventToDiscussionMapper) {
        this.resourceProducer = resourceProducer;
        this.eventProducer = eventProducer;
        this.eventToDiscussionMapper = eventToDiscussionMapper;
    }
}

