/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.finconsgroup.itserr.marketplace.discussion.bs.client.dm.DiscussionDmClient;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ResourceType;
import com.finconsgroup.itserr.marketplace.discussion.bs.mapper.EventToDiscussionMapper;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto.DiscussionMessagingAdditionalDataDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.UntypedMessagingEventDto;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CreationDiscussionUtility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreationDiscussionUtility.class);
    private final ObjectMapper objectMapper;
    private final EventToDiscussionMapper eventToDiscussionMapper;
    private final DiscussionDmClient discussionDmClient;

    public void create(String id, Object eventData, String eventType) {
        try {
            log.info("Processing news creation event for resource ID: {}", (Object)id);
            this.objectMapper.convertValue(eventData, UntypedMessagingEventDto.class);
            MessagingEventDto eventDto = this.convertToEventDto(eventData);
            DiscussionDTO discussionDto = this.eventToDiscussionMapper.toDiscussionDTO(eventDto);
            if (discussionDto != null) {
                discussionDto.setResourceType(eventType);
            } else {
                log.warn("Mapper returned null DiscussionDTO for event ID: {}. Skipping resourceType assignment.", (Object)id);
            }
            if (eventType.equals(ResourceType.FOLDER.getValue()) || eventType.equals(ResourceType.DOCUMENT.getValue())) {
                discussionDto.setVisibility("private");
            }
            this.discussionDmClient.createDiscussion(discussionDto);
        }
        catch (Exception e) {
            log.error("Failed to process news creation event for resource ID: {}", (Object)id, (Object)e);
            throw new RuntimeException("Failed to process news creation event", e);
        }
    }

    public MessagingEventDto<DiscussionMessagingAdditionalDataDto> convertToEventDto(Object eventData) {
        try {
            if (eventData == null) {
                throw new IllegalArgumentException("eventData must not be null");
            }
            return (MessagingEventDto)this.objectMapper.convertValue(eventData, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to convert event data to MessagingEventDto: {}", eventData, (Object)e);
            throw new IllegalArgumentException("Invalid event data format", e);
        }
    }

    @Generated
    public CreationDiscussionUtility(ObjectMapper objectMapper, EventToDiscussionMapper eventToDiscussionMapper, DiscussionDmClient discussionDmClient) {
        this.objectMapper = objectMapper;
        this.eventToDiscussionMapper = eventToDiscussionMapper;
        this.discussionDmClient = discussionDmClient;
    }
}

