package com.finconsgroup.itserr.marketplace.discussion.bs.bean;

import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.MessagingEventType;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.springframework.lang.NonNull;

/**
 * Application event when a user action is taken on Discussion Thread.
 */
@Getter
@EqualsAndHashCode(callSuper = true)
public class DiscussionThreadApplicationEvent extends DiscussionApplicationEvent {

    private final DiscussionThreadDetails threadDetails;

    public DiscussionThreadApplicationEvent(@NonNull DiscussionDTO source,
                                            @NonNull DiscussionThreadDetails threadDetails,
                                            @NonNull MessagingEventType eventType) {
        super(source, eventType);
        this.threadDetails = threadDetails;
    }

    /**
     * The discussion notification data on which the event occurred.
     *
     * @return the {@link DiscussionThreadDetails}
     */
    public DiscussionThreadDetails getDiscussionThreadDetails() {
        return threadDetails;
    }
}