package com.finconsgroup.itserr.marketplace.discussion.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.discussion.bs.api.AdminApi;
import com.finconsgroup.itserr.marketplace.discussion.bs.service.AdminService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RestController;

/**
 * REST controller for handling Discussion-related API requests.
 *
 * <p>Implements the {@link AdminApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class AdminController implements AdminApi {

    @Value("${discussion.bs.security.audience}")
    private String securityAudience;

    @Value("${discussion.bs.security.admin-role}")
    private String adminRole;

    private final AdminService adminService;

    @Override
    public void publishAllDiscussions(String resourceType, String visibility) {
        if (!JwtTokenHolder.getRoles(securityAudience).contains(adminRole)) {
            throw new WP2AuthorizationException("Forbidden");
        }

        adminService.publishAllMessages(resourceType, visibility);
    }
}
