package com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer;

import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import org.springframework.lang.NonNull;

/**
 * Message Producer responsible for publishing catalog-related resource messages
 */
public interface EventProducer {

    /**
     * Publishes an event message for created resource.
     *
     * @param resource the resource that was created
     */
    void publishCreatedEvent(@NonNull MessagingEventDto<?> resource);

    /**
     * Publishes an event message for updated resource.
     *
     * @param resource the resource that was updated
     */
    void publishUpdatedEvent(@NonNull MessagingEventDto<?> resource);

    /**
     * Publishes an event message for deleted resource.
     *
     * @param resource the resource that was deleted
     */
    void publishDeletedEvent(@NonNull MessagingEventDto<?> resource);

    /**
     * Publishes an event message for created thread resource.
     *
     * @param eventDto the thread resource that was created
     */
    void publishThreadCreatedEvent(@NonNull MessagingEventDto<?> eventDto);

}
