/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.mapper;

import com.finconsgroup.itserr.marketplace.discussion.bs.bean.DiscussionThreadDetails;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.mapper.EventToDiscussionMapper;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto.DiscussionMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto.DiscussionThreadMessagingAdditionalDataDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import java.time.Instant;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class EventToDiscussionMapperImpl
implements EventToDiscussionMapper {
    public DiscussionDTO toDiscussionDTO(MessagingEventDto<DiscussionMessagingAdditionalDataDto> dto) {
        if (dto == null) {
            return null;
        }
        DiscussionDTO.DiscussionDTOBuilder discussionDTO = DiscussionDTO.builder();
        discussionDTO.title(this.mapTitle(dto));
        discussionDTO.content(this.dtoAdditionalDataContent(dto));
        discussionDTO.createdBy(this.dtoUserUsername(dto));
        discussionDTO.resourceId(this.stringToUuid(dto.getId()));
        discussionDTO.url(this.dtoAdditionalDataImageUrl(dto));
        String visibility = this.dtoAdditionalDataVisibility(dto);
        if (visibility != null) {
            discussionDTO.visibility(visibility);
        } else {
            discussionDTO.visibility("public");
        }
        discussionDTO.createdAt(Instant.now());
        return discussionDTO.build();
    }

    public DiscussionThreadDetails toDiscussionThreadDetails(ThreadDTO thread, DiscussionDTO discussion, Set<String> usersToNotify) {
        Set<String> set;
        if (thread == null && discussion == null && usersToNotify == null) {
            return null;
        }
        DiscussionThreadDetails.DiscussionThreadDetailsBuilder discussionThreadDetails = DiscussionThreadDetails.builder();
        if (thread != null) {
            discussionThreadDetails.id(thread.getId());
            discussionThreadDetails.timestamp(this.localDateTimeToInstant(thread.getCreatedAt()));
        }
        if (discussion != null) {
            discussionThreadDetails.discussionId(discussion.getId());
            discussionThreadDetails.discussionTitle(discussion.getTitle());
            discussionThreadDetails.discussionResourceId(discussion.getResourceId());
            discussionThreadDetails.discussionResourceType(discussion.getResourceType());
        }
        if ((set = usersToNotify) != null) {
            discussionThreadDetails.usersToNotify(new LinkedHashSet<String>(set));
        }
        discussionThreadDetails.name("Discussion Thread");
        return discussionThreadDetails.build();
    }

    public MessagingEventDto<DiscussionThreadMessagingAdditionalDataDto> toMessagingEventDto(DiscussionThreadDetails discussionThreadDetails) {
        if (discussionThreadDetails == null) {
            return null;
        }
        MessagingEventDto messagingEventDto = new MessagingEventDto();
        messagingEventDto.setTitle(discussionThreadDetails.getDiscussionTitle());
        if (discussionThreadDetails.getId() != null) {
            messagingEventDto.setId(discussionThreadDetails.getId().toString());
        }
        messagingEventDto.setName(discussionThreadDetails.getName());
        messagingEventDto.setTimestamp(discussionThreadDetails.getTimestamp());
        return messagingEventDto;
    }

    public MessagingEventDto<DiscussionMessagingAdditionalDataDto> toMessagingEventDto(DiscussionDTO discussion) {
        if (discussion == null) {
            return null;
        }
        MessagingEventDto messagingEventDto = new MessagingEventDto();
        messagingEventDto.setCategory(discussion.getResourceType());
        if (discussion.getId() != null) {
            messagingEventDto.setId(discussion.getId().toString());
        }
        messagingEventDto.setTitle(discussion.getTitle());
        return messagingEventDto;
    }

    private String dtoAdditionalDataContent(MessagingEventDto<DiscussionMessagingAdditionalDataDto> messagingEventDto) {
        DiscussionMessagingAdditionalDataDto additionalData = (DiscussionMessagingAdditionalDataDto)messagingEventDto.getAdditionalData();
        if (additionalData == null) {
            return null;
        }
        return additionalData.getContent();
    }

    private String dtoUserUsername(MessagingEventDto<DiscussionMessagingAdditionalDataDto> messagingEventDto) {
        MessagingEventUserDto user = messagingEventDto.getUser();
        if (user == null) {
            return null;
        }
        return user.getUsername();
    }

    private String dtoAdditionalDataImageUrl(MessagingEventDto<DiscussionMessagingAdditionalDataDto> messagingEventDto) {
        DiscussionMessagingAdditionalDataDto additionalData = (DiscussionMessagingAdditionalDataDto)messagingEventDto.getAdditionalData();
        if (additionalData == null) {
            return null;
        }
        return additionalData.getImageUrl();
    }

    private String dtoAdditionalDataVisibility(MessagingEventDto<DiscussionMessagingAdditionalDataDto> messagingEventDto) {
        DiscussionMessagingAdditionalDataDto additionalData = (DiscussionMessagingAdditionalDataDto)messagingEventDto.getAdditionalData();
        if (additionalData == null) {
            return null;
        }
        return additionalData.getVisibility();
    }
}

