package com.finconsgroup.itserr.marketplace.discussion.bs.config.properties;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;


@Data
@Validated
@ConfigurationProperties(prefix = "discussion.bs")
public class DiscussionBsConfigurationProperties {

    /**
     * Represents the server URL for the Swagger API documentation.
     * This property is required and must not be blank.
     */
    @NotBlank
    private String swaggerApiServerUrl;
    /**
     * Indicates whether tests should fail in the absence of a running Docker environment.
     * This property ensures that the test execution enforces the prerequisite for Docker
     * when necessary.
     */
    @NotNull
    private boolean failsTestsOnMissingDocker;
    /**
     * Represents the messaging configuration properties for the application.
     * This property is validated to ensure that all nested properties within
     * {@link MessagingProperties} are correctly populated and valid.
     *
     * The messaging property encapsulates configurations related to different
     * messaging components such as events, items, news, and PI properties.
     * Each of these components is validated independently.
     */
    @NotNull
    @Valid
    private MessagingProperties messaging;

    /**
     * Configuration for messaging
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MessagingProperties {

        /**
         * Name of the configured producer
         */
        @NotBlank
        private String producerName;

        /**
         * Name of the configured event producer
         */
        @NotBlank
        private String eventProducerName;

        /**
         * Source identifier for events, used to indicate the origin of a message.
         */
        @NotBlank
        private String source;

        /**
         * Event type string used for resource creation.
         */
        @NotBlank
        private String resourceCreatedType;

        /**
         * Event type string used for resource update.
         */
        @NotBlank
        private String resourceUpdatedType;

        /**
         * Event type string used for resource deletion.
         */
        @NotBlank
        private String resourceDeletedType;

        /**
         * Event type string used for resource event creation.
         */
        @NotBlank
        private String resourceCreatedEventType;

        /**
         * Event type string used for resource event update.
         */
        @NotBlank
        private String resourceUpdatedEventType;

        /**
         * Event type string used for resource event deletion.
         */
        @NotBlank
        private String resourceDeletedEventType;

        /**
         * Event type string used for resource thread event creation.
         */
        @NotBlank
        private String resourceThreadCreatedEventType;

    }

    /**
     * Configuration properties for diagnostics-related features.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Diagnostics {
        /**
         * Controls whether the publish message diagnostic endpoint is enabled.
         */
        private boolean publishMessageEnabled;
    }
}
