/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.mapper;

import com.finconsgroup.itserr.marketplace.discussion.bs.bean.DiscussionThreadDetails;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto.DiscussionMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto.DiscussionThreadMessagingAdditionalDataDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import io.micrometer.common.util.StringUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Set;
import java.util.UUID;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;

@Mapper(componentModel="spring")
public interface EventToDiscussionMapper {
    @Mappings(value={@Mapping(source=".", target="title", qualifiedByName={"mapTitle"}), @Mapping(source="additionalData.content", target="content"), @Mapping(source="user.username", target="createdBy"), @Mapping(source="id", target="resourceId", qualifiedByName={"stringToUuid"}), @Mapping(source="additionalData.imageUrl", target="url"), @Mapping(source="additionalData.visibility", target="visibility", defaultValue="public"), @Mapping(expression="java(java.time.Instant.now())", target="createdAt"), @Mapping(ignore=true, target="resourceType"), @Mapping(ignore=true, target="id"), @Mapping(ignore=true, target="threads"), @Mapping(ignore=true, target="reactions"), @Mapping(ignore=true, target="reactionCounts"), @Mapping(ignore=true, target="userInfoDTO"), @Mapping(ignore=true, target="threadsCount"), @Mapping(ignore=true, target="updatedBy"), @Mapping(ignore=true, target="updatedAt")})
    public DiscussionDTO toDiscussionDTO(MessagingEventDto<DiscussionMessagingAdditionalDataDto> var1);

    @Named(value="mapTitle")
    default public String mapTitle(MessagingEventDto<DiscussionMessagingAdditionalDataDto> dto) {
        if (StringUtils.isBlank((String)dto.getTitle())) {
            return dto.getName();
        }
        return dto.getTitle();
    }

    @Mappings(value={@Mapping(source="thread.id", target="id"), @Mapping(source="thread.createdAt", target="timestamp", qualifiedByName={"localDateTimeToInstant"}), @Mapping(source="discussion.id", target="discussionId"), @Mapping(source="discussion.title", target="discussionTitle"), @Mapping(source="discussion.resourceId", target="discussionResourceId"), @Mapping(source="discussion.resourceType", target="discussionResourceType"), @Mapping(constant="Discussion Thread", target="name")})
    public DiscussionThreadDetails toDiscussionThreadDetails(ThreadDTO var1, DiscussionDTO var2, Set<String> var3);

    @Mappings(value={@Mapping(source="discussionTitle", target="title"), @Mapping(target="category", ignore=true), @Mapping(target="user", ignore=true), @Mapping(target="message", ignore=true), @Mapping(target="status", ignore=true), @Mapping(target="additionalData", ignore=true)})
    public MessagingEventDto<DiscussionThreadMessagingAdditionalDataDto> toMessagingEventDto(DiscussionThreadDetails var1);

    @Mappings(value={@Mapping(target="category", source="resourceType"), @Mapping(target="user", ignore=true), @Mapping(target="name", ignore=true), @Mapping(target="timestamp", ignore=true), @Mapping(target="message", ignore=true), @Mapping(target="status", ignore=true), @Mapping(target="additionalData", ignore=true)})
    public MessagingEventDto<DiscussionMessagingAdditionalDataDto> toMessagingEventDto(DiscussionDTO var1);

    @Named(value="localDateTimeToInstant")
    default public Instant localDateTimeToInstant(LocalDateTime localDateTime) {
        return localDateTime != null ? localDateTime.atZone(ZoneId.of("UTC")).toInstant() : null;
    }

    @Named(value="stringToUuid")
    default public UUID stringToUuid(String id) {
        return id != null ? UUID.fromString(id) : null;
    }
}

