/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.component;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.discussion.bs.bean.DiscussionApplicationEvent;
import com.finconsgroup.itserr.marketplace.discussion.bs.component.MessagingDiscussionApplicationEventListener;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.mapper.EventToDiscussionMapper;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto.DiscussionMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer.EventProducer;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer.ResourceProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MessagingDiscussionApplicationEventListener
implements ApplicationListener<DiscussionApplicationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingDiscussionApplicationEventListener.class);
    private final ResourceProducer resourceProducer;
    private final EventProducer eventProducer;
    private final EventToDiscussionMapper eventToDiscussionMapper;

    public void onApplicationEvent(@NonNull DiscussionApplicationEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        MessagingEventDto messagingEventDto = this.eventToDiscussionMapper.toMessagingEventDto(event.getDiscussion());
        MessagingEventUserDto user = MessagingEventUserDto.builder().id((UUID)JwtTokenHolder.getUserId().orElse(null)).name((String)JwtTokenHolder.getName().orElse(null)).username((String)JwtTokenHolder.getPreferredUsername().orElse(null)).build();
        messagingEventDto.setUser(user);
        DiscussionMessagingAdditionalDataDto additionalData = MessagingDiscussionApplicationEventListener.getDiscussionMessagingAdditionalDataDto((DiscussionApplicationEvent)event);
        messagingEventDto.setAdditionalData((Object)additionalData);
        this.updateEventForType(event, messagingEventDto);
        this.publishEventForType(event, messagingEventDto);
    }

    private void updateEventForType(DiscussionApplicationEvent applicationEvent, MessagingEventDto<DiscussionMessagingAdditionalDataDto> messagingEventDto) {
        DiscussionDTO discussionDTO = applicationEvent.getDiscussion();
        DiscussionMessagingAdditionalDataDto additionalData = MessagingDiscussionApplicationEventListener.getDiscussionMessagingAdditionalDataDto((DiscussionApplicationEvent)applicationEvent);
        switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$discussion$bs$enums$MessagingEventType[applicationEvent.getEventType().ordinal()]) {
            case 1: {
                messagingEventDto.setTimestamp(discussionDTO.getCreatedAt());
                break;
            }
            case 2: 
            case 3: {
                messagingEventDto.setTimestamp(applicationEvent.getEventTimestamp());
            }
        }
        messagingEventDto.setAdditionalData((Object)additionalData);
    }

    @NotNull
    private static DiscussionMessagingAdditionalDataDto getDiscussionMessagingAdditionalDataDto(@NotNull DiscussionApplicationEvent event) {
        DiscussionDTO discussionDTO = event.getDiscussion();
        DiscussionMessagingAdditionalDataDto additionalData = new DiscussionMessagingAdditionalDataDto();
        additionalData.setContent(discussionDTO.getContent());
        additionalData.setVisibility(discussionDTO.getVisibility());
        additionalData.setImageUrl(discussionDTO.getUrl());
        return additionalData;
    }

    private void publishEventForType(DiscussionApplicationEvent applicationEvent, MessagingEventDto<DiscussionMessagingAdditionalDataDto> messagingEventDto) {
        switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$discussion$bs$enums$MessagingEventType[applicationEvent.getEventType().ordinal()]) {
            case 1: {
                this.resourceProducer.publishCreatedResource(applicationEvent.getDiscussion());
                this.eventProducer.publishCreatedEvent(messagingEventDto);
                break;
            }
            case 2: {
                this.resourceProducer.publishUpdatedResource(applicationEvent.getDiscussion());
                this.eventProducer.publishUpdatedEvent(messagingEventDto);
                break;
            }
            case 3: {
                this.resourceProducer.publishDeletedResource(applicationEvent.getDiscussion());
                this.eventProducer.publishDeletedEvent(messagingEventDto);
            }
        }
    }

    @Generated
    public MessagingDiscussionApplicationEventListener(ResourceProducer resourceProducer, EventProducer eventProducer, EventToDiscussionMapper eventToDiscussionMapper) {
        this.resourceProducer = resourceProducer;
        this.eventProducer = eventProducer;
        this.eventToDiscussionMapper = eventToDiscussionMapper;
    }
}

