/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.dm.mapper;

import com.finconsgroup.itserr.marketplace.discussion.dm.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.DiscussionReactionDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadReactionDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Discussion;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.DiscussionReaction;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Thread;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.ThreadReaction;
import com.finconsgroup.itserr.marketplace.discussion.dm.mapper.DiscussionMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Component;

@Component
public class DiscussionMapperImpl
extends DiscussionMapper {
    public DiscussionDTO toDTO(Discussion discussion) {
        if (discussion == null) {
            return null;
        }
        DiscussionDTO.DiscussionDTOBuilder discussionDTO = DiscussionDTO.builder();
        discussionDTO.threads(this.mapThreadsToDTO(discussion.getThreads()));
        discussionDTO.id(discussion.getId());
        discussionDTO.title(discussion.getTitle());
        discussionDTO.content(discussion.getContent());
        discussionDTO.createdBy(discussion.getCreatedBy());
        discussionDTO.createdAt(discussion.getCreatedAt());
        discussionDTO.resourceId(discussion.getResourceId());
        discussionDTO.resourceType(discussion.getResourceType());
        discussionDTO.visibility(discussion.getVisibility());
        discussionDTO.url(discussion.getUrl());
        discussionDTO.updatedBy(discussion.getUpdatedBy());
        discussionDTO.updatedAt(discussion.getUpdatedAt());
        discussionDTO.reactions(this.discussionReactionListToDiscussionReactionDTOList(discussion.getReactions()));
        DiscussionDTO discussionDTOResult = discussionDTO.build();
        this.afterDiscussionToDTO(discussion, discussionDTOResult);
        return discussionDTOResult;
    }

    public DiscussionDTO toDTOWithoutThreads(Discussion discussion) {
        if (discussion == null) {
            return null;
        }
        DiscussionDTO.DiscussionDTOBuilder discussionDTO = DiscussionDTO.builder();
        discussionDTO.id(discussion.getId());
        discussionDTO.title(discussion.getTitle());
        discussionDTO.content(discussion.getContent());
        discussionDTO.createdBy(discussion.getCreatedBy());
        discussionDTO.createdAt(discussion.getCreatedAt());
        discussionDTO.resourceId(discussion.getResourceId());
        discussionDTO.resourceType(discussion.getResourceType());
        discussionDTO.visibility(discussion.getVisibility());
        discussionDTO.url(discussion.getUrl());
        discussionDTO.updatedBy(discussion.getUpdatedBy());
        discussionDTO.updatedAt(discussion.getUpdatedAt());
        discussionDTO.reactions(this.discussionReactionListToDiscussionReactionDTOList(discussion.getReactions()));
        DiscussionDTO discussionDTOResult = discussionDTO.build();
        this.afterDiscussionToDTO(discussion, discussionDTOResult);
        return discussionDTOResult;
    }

    public Discussion toEntity(DiscussionDTO discussionDTO) {
        if (discussionDTO == null) {
            return null;
        }
        Discussion.DiscussionBuilder discussion = Discussion.builder();
        discussion.id(discussionDTO.getId());
        discussion.title(discussionDTO.getTitle());
        discussion.content(discussionDTO.getContent());
        discussion.createdBy(discussionDTO.getCreatedBy());
        discussion.createdAt(discussionDTO.getCreatedAt());
        discussion.resourceId(discussionDTO.getResourceId());
        discussion.resourceType(discussionDTO.getResourceType());
        discussion.visibility(discussionDTO.getVisibility());
        discussion.url(discussionDTO.getUrl());
        discussion.updatedBy(discussionDTO.getUpdatedBy());
        discussion.updatedAt(discussionDTO.getUpdatedAt());
        return discussion.build();
    }

    public ThreadDTO mapThreadToDTO(Thread thread) {
        if (thread == null) {
            return null;
        }
        ThreadDTO.ThreadDTOBuilder threadDTO = ThreadDTO.builder();
        threadDTO.parentId(this.threadParentId(thread));
        threadDTO.id(thread.getId());
        threadDTO.createdBy(thread.getCreatedBy());
        threadDTO.createdAt(thread.getCreatedAt());
        threadDTO.modifiedAt(thread.getModifiedAt());
        threadDTO.content(thread.getContent());
        threadDTO.replies(this.mapThreadRepliesToDTO(thread.getReplies()));
        threadDTO.reactions(this.threadReactionListToThreadReactionDTOList(thread.getReactions()));
        ThreadDTO threadDTOResult = threadDTO.build();
        this.afterThreadToDTO(thread, threadDTOResult);
        return threadDTOResult;
    }

    public ThreadReactionDTO mapThreadReactionToDTO(ThreadReaction reaction) {
        if (reaction == null) {
            return null;
        }
        ThreadReactionDTO.ThreadReactionDTOBuilder threadReactionDTO = ThreadReactionDTO.builder();
        threadReactionDTO.id(reaction.getId());
        threadReactionDTO.userId(reaction.getUserId());
        threadReactionDTO.reaction(reaction.getReaction());
        threadReactionDTO.createdAt(reaction.getCreatedAt());
        return threadReactionDTO.build();
    }

    public DiscussionReactionDTO mapDiscussionReactionToDTO(DiscussionReaction reaction) {
        if (reaction == null) {
            return null;
        }
        DiscussionReactionDTO.DiscussionReactionDTOBuilder discussionReactionDTO = DiscussionReactionDTO.builder();
        discussionReactionDTO.id(reaction.getId());
        discussionReactionDTO.userId(reaction.getUserId());
        discussionReactionDTO.reaction(reaction.getReaction());
        discussionReactionDTO.createdAt(reaction.getCreatedAt());
        return discussionReactionDTO.build();
    }

    protected List<DiscussionReactionDTO> discussionReactionListToDiscussionReactionDTOList(List<DiscussionReaction> list) {
        if (list == null) {
            return null;
        }
        ArrayList<DiscussionReactionDTO> list1 = new ArrayList<DiscussionReactionDTO>(list.size());
        for (DiscussionReaction discussionReaction : list) {
            list1.add(this.mapDiscussionReactionToDTO(discussionReaction));
        }
        return list1;
    }

    private UUID threadParentId(Thread thread) {
        Thread parent = thread.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getId();
    }

    protected List<ThreadReactionDTO> threadReactionListToThreadReactionDTOList(List<ThreadReaction> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ThreadReactionDTO> list1 = new ArrayList<ThreadReactionDTO>(list.size());
        for (ThreadReaction threadReaction : list) {
            list1.add(this.mapThreadReactionToDTO(threadReaction));
        }
        return list1;
    }
}

