/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Discussion;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.DiscussionReaction;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Thread;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="discussions")
public class Discussion
extends AbstractUUIDEntity {
    private String title;
    @Column(columnDefinition="TEXT")
    private String content;
    private String createdBy;
    private Instant createdAt;
    private UUID resourceId;
    private String resourceType;
    private String visibility;
    private String url;
    private String updatedBy;
    private Instant updatedAt;
    @OneToMany(mappedBy="discussion", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Thread> threads;
    @OneToMany(mappedBy="discussion", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DiscussionReaction> reactions;

    public void prePersist() {
        super.prePersist();
        Instant currentTime = Instant.now();
        if (this.createdAt == null) {
            this.createdAt = currentTime;
        }
        if (this.updatedAt == null) {
            this.updatedAt = currentTime;
        }
        if ("social".equalsIgnoreCase(this.resourceType)) {
            this.resourceId = this.getId();
        }
    }

    @PreUpdate
    public void preUpdate() {
        this.updatedAt = Instant.now();
    }

    @Generated
    protected Discussion(DiscussionBuilder<?, ?> b) {
        super(b);
        this.title = b.title;
        this.content = b.content;
        this.createdBy = b.createdBy;
        this.createdAt = b.createdAt;
        this.resourceId = b.resourceId;
        this.resourceType = b.resourceType;
        this.visibility = b.visibility;
        this.url = b.url;
        this.updatedBy = b.updatedBy;
        this.updatedAt = b.updatedAt;
        this.threads = b.threads;
        this.reactions = b.reactions;
    }

    @Generated
    public static DiscussionBuilder<?, ?> builder() {
        return new DiscussionBuilderImpl();
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public UUID getResourceId() {
        return this.resourceId;
    }

    @Generated
    public String getResourceType() {
        return this.resourceType;
    }

    @Generated
    public String getVisibility() {
        return this.visibility;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Generated
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public List<Thread> getThreads() {
        return this.threads;
    }

    @Generated
    public List<DiscussionReaction> getReactions() {
        return this.reactions;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setResourceId(UUID resourceId) {
        this.resourceId = resourceId;
    }

    @Generated
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @Generated
    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Generated
    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setThreads(List<Thread> threads) {
        this.threads = threads;
    }

    @Generated
    public void setReactions(List<DiscussionReaction> reactions) {
        this.reactions = reactions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Discussion)) {
            return false;
        }
        Discussion other = (Discussion)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        UUID this$resourceId = this.getResourceId();
        UUID other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !((Object)this$resourceId).equals(other$resourceId)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$visibility = this.getVisibility();
        String other$visibility = other.getVisibility();
        if (this$visibility == null ? other$visibility != null : !this$visibility.equals(other$visibility)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        List this$threads = this.getThreads();
        List other$threads = other.getThreads();
        if (this$threads == null ? other$threads != null : !((Object)this$threads).equals(other$threads)) {
            return false;
        }
        List this$reactions = this.getReactions();
        List other$reactions = other.getReactions();
        return !(this$reactions == null ? other$reactions != null : !((Object)this$reactions).equals(other$reactions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Discussion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        UUID $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : ((Object)$resourceId).hashCode());
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : $visibility.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        List $threads = this.getThreads();
        result = result * 59 + ($threads == null ? 43 : ((Object)$threads).hashCode());
        List $reactions = this.getReactions();
        result = result * 59 + ($reactions == null ? 43 : ((Object)$reactions).hashCode());
        return result;
    }

    @Generated
    public Discussion() {
    }
}

