/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.bs.component;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.event.bs.bean.EventApplicationEvent;
import com.finconsgroup.itserr.marketplace.event.bs.component.MessagingEventApplicationEventListener;
import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.bs.enums.MessagingEventType;
import com.finconsgroup.itserr.marketplace.event.bs.mapper.EventMapper;
import com.finconsgroup.itserr.marketplace.event.bs.messaging.EventProducer;
import com.finconsgroup.itserr.marketplace.event.bs.messaging.ResourceProducer;
import com.finconsgroup.itserr.marketplace.event.bs.messaging.dto.EventCreatedMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.event.bs.messaging.dto.EventMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.event.bs.messaging.dto.EventSubscriptionMessagingAdditionalDataDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class MessagingEventApplicationEventListener
implements ApplicationListener<EventApplicationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingEventApplicationEventListener.class);
    private final EventProducer eventProducer;
    private final ResourceProducer resourceProducer;
    private final EventMapper eventMapper;

    public MessagingEventApplicationEventListener(EventProducer eventProducer, ResourceProducer resourceProducer, EventMapper eventMapper) {
        this.eventProducer = eventProducer;
        this.resourceProducer = resourceProducer;
        this.eventMapper = eventMapper;
    }

    public void onApplicationEvent(@NonNull EventApplicationEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        MessagingEventDto messagingEventDto = this.eventMapper.toMessagingEventDto(event.getEvent());
        MessagingEventUserDto user = MessagingEventUserDto.builder().id((UUID)JwtTokenHolder.getUserId().orElse(null)).name((String)JwtTokenHolder.getName().orElse(null)).username((String)JwtTokenHolder.getPreferredUsername().orElse(null)).build();
        messagingEventDto.setUser(user);
        this.updateEventForType(event, messagingEventDto);
        this.publishEventForType(event, messagingEventDto);
    }

    private void updateEventForType(EventApplicationEvent applicationEvent, MessagingEventDto<EventMessagingAdditionalDataDto> messagingEventDto) {
        OutputEventDto outputEventDto = applicationEvent.getEvent();
        EventMessagingAdditionalDataDto additionalData = null;
        switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$event$bs$enums$MessagingEventType[applicationEvent.getEventType().ordinal()]) {
            case 1: {
                additionalData = this.createAdditionalData(applicationEvent.getEventType());
                messagingEventDto.setTimestamp(outputEventDto.getCreationTime());
                this.updateAdditionalDataForCreated(additionalData, outputEventDto);
                break;
            }
            case 2: {
                messagingEventDto.setTimestamp(outputEventDto.getUpdateTime());
                break;
            }
            case 3: {
                messagingEventDto.setTimestamp(applicationEvent.getEventTimestamp());
                break;
            }
            case 4: 
            case 5: {
                additionalData = this.createAdditionalData(applicationEvent.getEventType());
                messagingEventDto.setTimestamp(outputEventDto.getUpdateTime());
                this.updateAdditionalDataForSubscription(additionalData, outputEventDto, applicationEvent.getEventType());
            }
        }
        messagingEventDto.setAdditionalData(additionalData);
    }

    private EventMessagingAdditionalDataDto createAdditionalData(MessagingEventType eventType) {
        return switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$event$bs$enums$MessagingEventType[eventType.ordinal()]) {
            case 1 -> new EventCreatedMessagingAdditionalDataDto();
            case 4, 5 -> new EventSubscriptionMessagingAdditionalDataDto();
            default -> new EventMessagingAdditionalDataDto();
        };
    }

    private void updateAdditionalDataForCreated(EventMessagingAdditionalDataDto additionalData, OutputEventDto outputEventDto) {
        if (additionalData instanceof EventCreatedMessagingAdditionalDataDto) {
            EventCreatedMessagingAdditionalDataDto createdAdditionalDataDto = (EventCreatedMessagingAdditionalDataDto)additionalData;
            createdAdditionalDataDto.setContent(outputEventDto.getContent());
            if (outputEventDto.getImage() != null) {
                createdAdditionalDataDto.setImageUrl(outputEventDto.getImage().getUrl());
            }
        }
    }

    private void updateAdditionalDataForSubscription(EventMessagingAdditionalDataDto additionalData, OutputEventDto outputEventDto, MessagingEventType eventType) {
        if (additionalData instanceof EventSubscriptionMessagingAdditionalDataDto) {
            EventSubscriptionMessagingAdditionalDataDto subscriptionAdditionalDataDto = (EventSubscriptionMessagingAdditionalDataDto)additionalData;
            subscriptionAdditionalDataDto.setNotifyUserIds(List.of(outputEventDto.getMaintainer().getId().toString()));
            subscriptionAdditionalDataDto.setSubscribed(Boolean.valueOf(eventType == MessagingEventType.REGISTER));
            subscriptionAdditionalDataDto.setStartDate(outputEventDto.getStartDate());
        }
    }

    private void publishEventForType(EventApplicationEvent applicationEvent, MessagingEventDto<?> messagingEventDto) {
        switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$event$bs$enums$MessagingEventType[applicationEvent.getEventType().ordinal()]) {
            case 1: {
                this.resourceProducer.publishCreatedResource(applicationEvent.getEvent());
                this.eventProducer.publishCreateEvent(messagingEventDto);
                break;
            }
            case 2: {
                this.resourceProducer.publishUpdatedResource(applicationEvent.getEvent());
                this.eventProducer.publishUpdateEvent(messagingEventDto);
                break;
            }
            case 3: {
                this.resourceProducer.publishDeletedResource(applicationEvent.getEvent());
                this.eventProducer.publishDeleteEvent(messagingEventDto);
                break;
            }
            case 4: 
            case 5: {
                this.resourceProducer.publishUpdatedResource(applicationEvent.getEvent());
                this.eventProducer.publishSubscriptionEvent(messagingEventDto);
            }
        }
    }
}

