/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.bs.api;

import com.finconsgroup.itserr.marketplace.event.bs.enums.MessagingEventType;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="Diagnostics", description="Diagnostics API: provides endpoints used for debugging and runtime analysis.")
@SecurityRequirement(name="BearerAuth")
public interface DiagnosticsApi {
    @Operation(summary="Download log file", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(path={"/event/diagnostics/download-logs"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> downloadLogs();

    @Operation(summary="Test method to send event event message", description="Simulates publishing events for event changes (creation, update or deletion)", responses={@ApiResponse(responseCode="200", description="Message sent successfully"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="404", description="Item not found (for update/delete operations)")})
    @GetMapping(path={"/event/diagnostics/publish-message"}, produces={"application/json"})
    public ResponseEntity<String> publishMessage(@RequestParam(name="eventType", required=false) MessagingEventType var1, @RequestParam(name="name", required=false, defaultValue="item name") String var2);
}

