/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.event.bs.api.DiagnosticsApi;
import com.finconsgroup.itserr.marketplace.event.bs.bean.EventApplicationEvent;
import com.finconsgroup.itserr.marketplace.event.bs.bean.EventSubscriptionApplicationEvent;
import com.finconsgroup.itserr.marketplace.event.bs.configuration.properties.EventBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.bs.enums.MessagingEventType;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class DiagnosticsController
implements DiagnosticsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsController.class);
    private final ApplicationEventPublisher applicationEventPublisher;
    private final EventBsConfigurationProperties eventBsConfigurationProperties;
    private static final Map<String, OutputEventDto> itemMap = new HashMap();
    @Value(value="${log.log4j2-rolling-file-name}")
    private String log4j2RollingFileName;

    public ResponseEntity<Resource> downloadLogs() {
        log.debug("call to DiagnosticsController - downloadLogs");
        Path filePath = Paths.get(this.getLogFilePathFromLog4j2(), new String[0]);
        log.debug("Trying to retrieve log file from: {}", (Object)filePath);
        File logFile = filePath.toFile();
        if (!logFile.exists() || !logFile.isFile()) {
            throw new WP2ResourceNotFoundException("Log file not found: %s".formatted(logFile.getAbsolutePath()));
        }
        FileSystemResource resource = new FileSystemResource(logFile);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{DiagnosticsController.getContentDispositionHeaderValue((String)logFile.getName())})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    public String getLogFilePathFromLog4j2() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        RollingFileAppender appender = (RollingFileAppender)context.getConfiguration().getAppender(this.log4j2RollingFileName);
        return appender.getFileName();
    }

    private static String getContentDispositionHeaderValue(String fileName) {
        return "attachment; filename=\"%s\"".formatted(fileName);
    }

    public ResponseEntity<String> publishMessage(MessagingEventType messagingEventType, String itemName) {
        OutputEventDto eventDto;
        if (!this.eventBsConfigurationProperties.getDiagnostics().isPublishMessageEnabled()) {
            log.warn("Attempt to access disabled diagnostics endpoint");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled in the current environment");
        }
        log.debug("call to DiagnosticsController - publishMessage, name: %s".formatted(itemName));
        MessagingEventType messagingEventType2 = messagingEventType;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CREATED", "UPDATED", "DELETED", "REGISTER", "UNREGISTER"}, (MessagingEventType)messagingEventType2, n)) {
            case 0: {
                eventDto = ((OutputEventDto.OutputEventDtoBuilder)((OutputEventDto.OutputEventDtoBuilder)((OutputEventDto.OutputEventDtoBuilder)OutputEventDto.builder().id(UUID.randomUUID())).title(itemName)).content("CREATED News content")).build();
                log.info("sending created event message, eventDto: {}", (Object)eventDto);
                itemMap.put(eventDto.getTitle(), eventDto);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new EventApplicationEvent(eventDto, MessagingEventType.CREATED));
                break;
            }
            case 1: {
                eventDto = (OutputEventDto)itemMap.get(itemName);
                if (eventDto == null) {
                    return ResponseEntity.badRequest().body((Object)"no test item created for itemName: %s".formatted(itemName));
                }
                eventDto.setContent("the UPDATED content");
                log.info("sending updated event message, eventDto: {}", (Object)eventDto);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new EventApplicationEvent(eventDto, MessagingEventType.UPDATED));
                break;
            }
            case 2: {
                eventDto = (OutputEventDto)itemMap.get(itemName);
                if (eventDto == null) {
                    return ResponseEntity.badRequest().body((Object)"no test item created for itemName: %s".formatted(itemName));
                }
                log.info("sending deleted message, eventDto: {}", (Object)eventDto);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new EventApplicationEvent(eventDto, MessagingEventType.DELETED));
                itemMap.remove(eventDto.getTitle());
                break;
            }
            case 3: {
                eventDto = (OutputEventDto)itemMap.get(itemName);
                if (eventDto == null) {
                    return ResponseEntity.badRequest().body((Object)"no test item created for itemName: %s".formatted(itemName));
                }
                log.info("sending register message, eventDto: {}", (Object)eventDto);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new EventSubscriptionApplicationEvent(eventDto, MessagingEventType.REGISTER));
                break;
            }
            case 4: {
                eventDto = (OutputEventDto)itemMap.get(itemName);
                if (eventDto == null) {
                    return ResponseEntity.badRequest().body((Object)"no test item created for itemName: %s".formatted(itemName));
                }
                log.info("sending unregister message, eventDto: {}", (Object)eventDto);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new EventSubscriptionApplicationEvent(eventDto, MessagingEventType.UNREGISTER));
                break;
            }
            default: {
                return ResponseEntity.badRequest().body((Object)"Event type must be one of: CREATED, UPDATED, DELETED, REGISTER or UNREGISTER");
            }
        }
        return ResponseEntity.ok((Object)"message sent correctly, eventDto: %s".formatted(eventDto));
    }

    @Generated
    public DiagnosticsController(ApplicationEventPublisher applicationEventPublisher, EventBsConfigurationProperties eventBsConfigurationProperties) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.eventBsConfigurationProperties = eventBsConfigurationProperties;
    }
}

