package com.finconsgroup.itserr.marketplace.event.bs.bean;

import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.bs.enums.MessagingEventType;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.NonNull;

import java.time.Instant;

/**
 * Application event when a user action is taken on Event.
 */
@Getter
@EqualsAndHashCode(callSuper = true)
public class EventApplicationEvent extends ApplicationEvent {

    private final MessagingEventType eventType;
    private final Instant eventTimestamp;

    public EventApplicationEvent(@NonNull OutputEventDto source,
                                 @NonNull MessagingEventType eventType) {
        super(source);
        this.eventType = eventType;
        this.eventTimestamp = Instant.now();
    }

    /**
     * The event on which the event occurred.
     *
     * @return the {@link OutputEventDto}
     */
    public OutputEventDto getEvent() {
        return (OutputEventDto) getSource();
    }

}
